/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class FieldCapabilitiesFailure
implements Writeable,
ToXContentObject {
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField FAILURE_FIELD = new ParseField("failure", new String[0]);
    private final List<String> indices;
    private final Exception exception;

    public FieldCapabilitiesFailure(String[] indices, Exception exception) {
        this.indices = new ArrayList<String>(Arrays.asList(Objects.requireNonNull(indices)));
        this.exception = Objects.requireNonNull(exception);
    }

    public FieldCapabilitiesFailure(StreamInput in) throws IOException {
        this.indices = in.readStringCollectionAsList();
        this.exception = in.readException();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.stringListField(INDICES_FIELD.getPreferredName(), this.indices);
        builder.startObject(FAILURE_FIELD.getPreferredName());
        ElasticsearchException.generateFailureXContent(builder, params, this.exception, true);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indices);
        out.writeException(this.exception);
    }

    public String[] getIndices() {
        return (String[])this.indices.toArray(String[]::new);
    }

    public Exception getException() {
        return this.exception;
    }

    FieldCapabilitiesFailure addIndex(String index) {
        this.indices.add(index);
        return this;
    }
}

