/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchableSnapshotAction
implements JsonpSerializable {
    private final String snapshotRepository;
    @Nullable
    private final Boolean forceMergeIndex;
    public static final JsonpDeserializer<SearchableSnapshotAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchableSnapshotAction::setupSearchableSnapshotActionDeserializer);

    private SearchableSnapshotAction(Builder builder) {
        this.snapshotRepository = ApiTypeHelper.requireNonNull(builder.snapshotRepository, this, "snapshotRepository");
        this.forceMergeIndex = builder.forceMergeIndex;
    }

    public static SearchableSnapshotAction of(Function<Builder, ObjectBuilder<SearchableSnapshotAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String snapshotRepository() {
        return this.snapshotRepository;
    }

    @Nullable
    public final Boolean forceMergeIndex() {
        return this.forceMergeIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("snapshot_repository");
        generator.write(this.snapshotRepository);
        if (this.forceMergeIndex != null) {
            generator.writeKey("force_merge_index");
            generator.write(this.forceMergeIndex);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSearchableSnapshotActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::snapshotRepository, JsonpDeserializer.stringDeserializer(), "snapshot_repository");
        op.add(Builder::forceMergeIndex, JsonpDeserializer.booleanDeserializer(), "force_merge_index");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SearchableSnapshotAction> {
        private String snapshotRepository;
        @Nullable
        private Boolean forceMergeIndex;

        public final Builder snapshotRepository(String value) {
            this.snapshotRepository = value;
            return this;
        }

        public final Builder forceMergeIndex(@Nullable Boolean value) {
            this.forceMergeIndex = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchableSnapshotAction build() {
            this._checkSingleUse();
            return new SearchableSnapshotAction(this);
        }
    }
}

