/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.time.Instant;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ReadableMatchers {
    private static final DateFormatter dateFormatter = DateFormatter.forPattern((String)"strict_date_optional_time");

    public static DateMillisMatcher matchesDateMillis(String date) {
        return new DateMillisMatcher(date);
    }

    public static DateNanosMatcher matchesDateNanos(String date) {
        return new DateNanosMatcher(date);
    }

    public static StringBytesRefMatcher matchesBytesRef(String string) {
        return new StringBytesRefMatcher(string);
    }

    public static class DateMillisMatcher
    extends TypeSafeMatcher<Long> {
        private final long timeMillis;

        public DateMillisMatcher(String date) {
            this.timeMillis = Instant.parse(date).toEpochMilli();
        }

        public boolean matchesSafely(Long item) {
            return this.timeMillis == item;
        }

        public void describeMismatchSafely(Long item, Description description) {
            description.appendText("was ").appendValue((Object)dateFormatter.formatMillis(item.longValue()));
        }

        public void describeTo(Description description) {
            description.appendText(dateFormatter.formatMillis(this.timeMillis));
        }
    }

    public static class DateNanosMatcher
    extends TypeSafeMatcher<Long> {
        private final long timeNanos;

        public DateNanosMatcher(String date) {
            this.timeNanos = DateUtils.toLong((Instant)Instant.parse(date));
        }

        public boolean matchesSafely(Long item) {
            return this.timeNanos == item;
        }

        public void describeMismatchSafely(Long item, Description description) {
            description.appendText("was ").appendValue((Object)dateFormatter.formatNanos(item.longValue()));
        }

        public void describeTo(Description description) {
            description.appendText(dateFormatter.formatNanos(this.timeNanos));
        }
    }

    public static class StringBytesRefMatcher
    extends TypeSafeMatcher<BytesRef> {
        private final String string;
        private final BytesRef bytesRef;

        public StringBytesRefMatcher(String string) {
            this.string = string;
            this.bytesRef = new BytesRef((CharSequence)string);
        }

        protected boolean matchesSafely(BytesRef item) {
            return item.equals((Object)this.bytesRef);
        }

        public void describeMismatchSafely(BytesRef item, Description description) {
            description.appendText("was ").appendValue((Object)item.utf8ToString());
        }

        public void describeTo(Description description) {
            description.appendText(this.string);
        }
    }
}

