/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.function.BiConsumer;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TestShardRoutingRoleStrategies;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.routing.GlobalRoutingTable;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.common.collect.ImmutableOpenMap;

public final class GlobalRoutingTableTestHelper {
    public static GlobalRoutingTable buildRoutingTable(Metadata metadata, BiConsumer<RoutingTable.Builder, IndexMetadata> indexConsumer) {
        ImmutableOpenMap.Builder projectRouting = ImmutableOpenMap.builder((int)metadata.projects().size());
        metadata.projects().forEach((projectId, projectMetadata) -> {
            RoutingTable.Builder rtBuilder = RoutingTable.builder((ShardRoutingRoleStrategy)TestShardRoutingRoleStrategies.DEFAULT_ROLE_ONLY);
            projectMetadata.indices().values().forEach(indexMetadata -> indexConsumer.accept(rtBuilder, (IndexMetadata)indexMetadata));
            projectRouting.put(projectId, (Object)rtBuilder.build());
        });
        return new GlobalRoutingTable(projectRouting.build());
    }

    public static GlobalRoutingTable updateRoutingTable(ClusterState clusterState, BiConsumer<RoutingTable.Builder, IndexMetadata> newIndicesConsumer) {
        return GlobalRoutingTableTestHelper.updateRoutingTable(clusterState, newIndicesConsumer, (ignoreBuilder, ignoreIndex) -> {});
    }

    public static GlobalRoutingTable updateRoutingTable(ClusterState clusterState, BiConsumer<RoutingTable.Builder, IndexMetadata> newIndicesConsumer, BiConsumer<RoutingTable.Builder, IndexMetadata> updateIndicesConsumer) {
        GlobalRoutingTable.Builder globalBuilder = GlobalRoutingTable.builder((GlobalRoutingTable)clusterState.globalRoutingTable());
        clusterState.metadata().projects().forEach((projectId, projectMetadata) -> {
            RoutingTable existingRoutingTable = clusterState.routingTable(projectId);
            RoutingTable.Builder rtBuilder = existingRoutingTable == null ? RoutingTable.builder((ShardRoutingRoleStrategy)TestShardRoutingRoleStrategies.DEFAULT_ROLE_ONLY) : RoutingTable.builder((ShardRoutingRoleStrategy)TestShardRoutingRoleStrategies.DEFAULT_ROLE_ONLY, (RoutingTable)existingRoutingTable);
            projectMetadata.indices().values().forEach(indexMetadata -> {
                if (existingRoutingTable != null && existingRoutingTable.hasIndex(indexMetadata.getIndex())) {
                    updateIndicesConsumer.accept(rtBuilder, (IndexMetadata)indexMetadata);
                } else {
                    newIndicesConsumer.accept(rtBuilder, (IndexMetadata)indexMetadata);
                }
            });
            globalBuilder.put(projectId, rtBuilder.build());
        });
        return globalBuilder.build();
    }

    private GlobalRoutingTableTestHelper() {
    }

    public static GlobalRoutingTable routingTable(ProjectId projectId, RoutingTable.Builder projectRouting) {
        return GlobalRoutingTableTestHelper.routingTable(projectId, projectRouting.build());
    }

    public static GlobalRoutingTable routingTable(ProjectId projectId, RoutingTable projectRouting) {
        return GlobalRoutingTable.builder().put(projectId, projectRouting).build();
    }

    public static GlobalRoutingTable routingTable(ProjectId projectId, IndexRoutingTable ... indexRouting) {
        RoutingTable.Builder rt = RoutingTable.builder();
        for (IndexRoutingTable irt : indexRouting) {
            rt.add(irt);
        }
        return GlobalRoutingTableTestHelper.routingTable(projectId, rt);
    }
}

