/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.inference;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.GeneratingPlan;
import org.elasticsearch.xpack.esql.plan.logical.ExecutesOn;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.Streaming;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public abstract class InferencePlan<PlanType extends InferencePlan<PlanType>>
extends UnaryPlan
implements Streaming,
SortAgnostic,
GeneratingPlan<InferencePlan<PlanType>>,
ExecutesOn.Coordinator {
    public static final String INFERENCE_ID_OPTION_NAME = "inference_id";
    public static final List<String> VALID_INFERENCE_OPTION_NAMES = List.of("inference_id");
    private final Expression inferenceId;

    protected InferencePlan(Source source, LogicalPlan child, Expression inferenceId) {
        super(source, child);
        this.inferenceId = inferenceId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.inferenceId());
    }

    public Expression inferenceId() {
        return this.inferenceId;
    }

    @Override
    public boolean expressionsResolved() {
        return this.inferenceId.resolved();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InferencePlan other = (InferencePlan)o;
        return Objects.equals(this.inferenceId(), other.inferenceId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inferenceId());
    }

    public abstract TaskType taskType();

    public abstract PlanType withInferenceId(Expression var1);

    public PlanType withInferenceResolutionError(String inferenceId, String error) {
        return this.withInferenceId((Expression)new UnresolvedAttribute(this.inferenceId().source(), inferenceId, error));
    }

    public List<String> validOptionNames() {
        return VALID_INFERENCE_OPTION_NAMES;
    }

    public abstract boolean isFoldable();
}

