/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Least;

public final class LeastIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LeastIntEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;
    private Warnings warnings;

    public LeastIntEvaluator(Source source, EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.source = source;
        this.values = values;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        IntBlock[] valuesBlocks = new IntBlock[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesBlocks);){
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesBlocks[i] = (IntBlock)this.values[i].eval(page);
            }
            IntVector[] valuesVectors = new IntVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                IntBlock intBlock = this.eval(page.getPositionCount(), valuesBlocks);
                return intBlock;
            }
            IntBlock intBlock = this.eval(page.getPositionCount(), valuesVectors).asBlock();
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        for (EvalOperator.ExpressionEvaluator e : this.values) {
            baseRamBytesUsed += e.baseRamBytesUsed();
        }
        return baseRamBytesUsed;
    }

    public IntBlock eval(int positionCount, IntBlock[] valuesBlocks) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            int[] valuesValues = new int[this.values.length];
            block9: for (int p = 0; p < positionCount; ++p) {
                int i;
                block10: for (i = 0; i < valuesBlocks.length; ++i) {
                    switch (valuesBlocks[i].getValueCount(p)) {
                        case 0: {
                            result.appendNull();
                            continue block9;
                        }
                        case 1: {
                            continue block10;
                        }
                        default: {
                            this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                            result.appendNull();
                            continue block9;
                        }
                    }
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getInt(o);
                }
                result.appendInt(Least.process(valuesValues));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector[] valuesVectors) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            int[] valuesValues = new int[this.values.length];
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getInt(p);
                }
                result.appendInt(p, Least.process(valuesValues));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "LeastIntEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException(() -> Releasables.close((Releasable[])this.values));
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory[] values;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory[] values) {
            this.source = source;
            this.values = values;
        }

        public LeastIntEvaluator get(DriverContext context) {
            EvalOperator.ExpressionEvaluator[] values = (EvalOperator.ExpressionEvaluator[])Arrays.stream(this.values).map(a -> a.get(context)).toArray(EvalOperator.ExpressionEvaluator[]::new);
            return new LeastIntEvaluator(this.source, values, context);
        }

        public String toString() {
            return "LeastIntEvaluator[values=" + Arrays.toString(this.values) + "]";
        }
    }
}

