/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.core.security.authc.service.ServiceAccountTokenStore;

public final class CompositeServiceAccountTokenStore
implements ServiceAccountTokenStore {
    private static final Logger logger = LogManager.getLogger(CompositeServiceAccountTokenStore.class);
    private final ThreadContext threadContext;
    private final List<ServiceAccountTokenStore> stores;

    public CompositeServiceAccountTokenStore(List<ServiceAccountTokenStore> stores, ThreadContext threadContext) {
        this.stores = stores;
        this.threadContext = threadContext;
    }

    public void authenticate(ServiceAccountToken token, ActionListener<ServiceAccountTokenStore.StoreAuthenticationResult> listener) {
        IteratingActionListener authenticatingListener = new IteratingActionListener(listener, (store, successListener) -> store.authenticate(token, successListener), this.stores, this.threadContext, Function.identity(), storeAuthenticationResult -> !storeAuthenticationResult.isSuccess());
        try {
            authenticatingListener.run();
        }
        catch (Exception e) {
            logger.debug(() -> "authentication of service token [" + token.getQualifiedName() + "] failed", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

