/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchStats
implements Writeable,
ToXContentFragment {
    private final Stats totalStats;
    private long openContexts;
    @Nullable
    private Map<String, Stats> groupStats;

    public SearchStats() {
        this.totalStats = new Stats();
    }

    public SearchStats(Stats totalStats, long openContexts, @Nullable Map<String, Stats> groupStats) {
        this.totalStats = totalStats;
        this.openContexts = openContexts;
        this.groupStats = groupStats;
    }

    public SearchStats(StreamInput in) throws IOException {
        this.totalStats = Stats.readStats(in);
        this.openContexts = in.readVLong();
        if (in.readBoolean()) {
            this.groupStats = in.readMap(Stats::readStats);
        }
    }

    public void add(SearchStats searchStats) {
        if (searchStats == null) {
            return;
        }
        this.addTotals(searchStats);
        this.openContexts += searchStats.openContexts;
        if (searchStats.groupStats != null && !searchStats.groupStats.isEmpty()) {
            if (this.groupStats == null) {
                this.groupStats = Maps.newMapWithExpectedSize(searchStats.groupStats.size());
            }
            for (Map.Entry<String, Stats> entry : searchStats.groupStats.entrySet()) {
                this.groupStats.putIfAbsent(entry.getKey(), new Stats());
                this.groupStats.get(entry.getKey()).add(entry.getValue());
            }
        }
    }

    public void addTotals(SearchStats searchStats) {
        if (searchStats == null) {
            return;
        }
        this.totalStats.add(searchStats.totalStats);
    }

    public void addTotalsForClosingShard(SearchStats searchStats) {
        if (searchStats == null) {
            return;
        }
        this.totalStats.addForClosingShard(searchStats.totalStats);
    }

    public Stats getTotal() {
        return this.totalStats;
    }

    public long getOpenContexts() {
        return this.openContexts;
    }

    @Nullable
    public Map<String, Stats> getGroupStats() {
        return this.groupStats != null ? Collections.unmodifiableMap(this.groupStats) : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("search");
        builder.field("open_contexts", this.openContexts);
        this.totalStats.toXContent(builder, params);
        if (this.groupStats != null && !this.groupStats.isEmpty()) {
            builder.startObject("groups");
            for (Map.Entry<String, Stats> entry : this.groupStats.entrySet()) {
                builder.startObject(entry.getKey());
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        out.writeVLong(this.openContexts);
        if (this.groupStats == null || this.groupStats.isEmpty()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.groupStats, StreamOutput::writeWriteable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchStats that = (SearchStats)o;
        return Objects.equals(this.totalStats, that.totalStats) && this.openContexts == that.openContexts && Objects.equals(this.groupStats, that.groupStats);
    }

    public int hashCode() {
        return Objects.hash(this.totalStats, this.openContexts, this.groupStats);
    }

    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private static final TransportVersion SEARCH_LOAD_PER_INDEX_STATS = TransportVersion.fromName("search_load_per_index_stats");
        private long queryCount;
        private long queryTimeInMillis;
        private long queryCurrent;
        private long fetchCount;
        private long fetchTimeInMillis;
        private long fetchCurrent;
        private long scrollCount;
        private long scrollTimeInMillis;
        private long scrollCurrent;
        private long suggestCount;
        private long suggestTimeInMillis;
        private long suggestCurrent;
        private long queryFailure;
        private long fetchFailure;
        private double recentSearchLoad;

        private Stats() {
        }

        public Stats(long queryCount, long queryTimeInMillis, long queryCurrent, long queryFailure, long fetchCount, long fetchTimeInMillis, long fetchCurrent, long fetchFailure, long scrollCount, long scrollTimeInMillis, long scrollCurrent, long suggestCount, long suggestTimeInMillis, long suggestCurrent, double recentSearchLoad) {
            this.queryCount = queryCount;
            this.queryTimeInMillis = queryTimeInMillis;
            this.queryCurrent = queryCurrent;
            this.queryFailure = queryFailure;
            this.fetchCount = fetchCount;
            this.fetchTimeInMillis = fetchTimeInMillis;
            this.fetchCurrent = fetchCurrent;
            this.fetchFailure = fetchFailure;
            this.scrollCount = scrollCount;
            this.scrollTimeInMillis = scrollTimeInMillis;
            this.scrollCurrent = scrollCurrent;
            this.suggestCount = suggestCount;
            this.suggestTimeInMillis = suggestTimeInMillis;
            this.suggestCurrent = suggestCurrent;
            this.recentSearchLoad = recentSearchLoad;
        }

        private Stats(StreamInput in) throws IOException {
            this.queryCount = in.readVLong();
            this.queryTimeInMillis = in.readVLong();
            this.queryCurrent = in.readVLong();
            this.fetchCount = in.readVLong();
            this.fetchTimeInMillis = in.readVLong();
            this.fetchCurrent = in.readVLong();
            this.scrollCount = in.readVLong();
            this.scrollTimeInMillis = in.readVLong();
            this.scrollCurrent = in.readVLong();
            this.suggestCount = in.readVLong();
            this.suggestTimeInMillis = in.readVLong();
            this.suggestCurrent = in.readVLong();
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
                this.queryFailure = in.readVLong();
                this.fetchFailure = in.readVLong();
            }
            if (in.getTransportVersion().supports(SEARCH_LOAD_PER_INDEX_STATS)) {
                this.recentSearchLoad = in.readDouble();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.queryCount);
            out.writeVLong(this.queryTimeInMillis);
            out.writeVLong(this.queryCurrent);
            out.writeVLong(this.fetchCount);
            out.writeVLong(this.fetchTimeInMillis);
            out.writeVLong(this.fetchCurrent);
            out.writeVLong(this.scrollCount);
            out.writeVLong(this.scrollTimeInMillis);
            out.writeVLong(this.scrollCurrent);
            out.writeVLong(this.suggestCount);
            out.writeVLong(this.suggestTimeInMillis);
            out.writeVLong(this.suggestCurrent);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
                out.writeVLong(this.queryFailure);
                out.writeVLong(this.fetchFailure);
            }
            if (out.getTransportVersion().supports(SEARCH_LOAD_PER_INDEX_STATS)) {
                out.writeDouble(this.recentSearchLoad);
            }
        }

        public void add(Stats stats) {
            this.queryCount += stats.queryCount;
            this.queryTimeInMillis += stats.queryTimeInMillis;
            this.queryCurrent += stats.queryCurrent;
            this.queryFailure += stats.queryFailure;
            this.fetchCount += stats.fetchCount;
            this.fetchTimeInMillis += stats.fetchTimeInMillis;
            this.fetchCurrent += stats.fetchCurrent;
            this.fetchFailure += stats.fetchFailure;
            this.scrollCount += stats.scrollCount;
            this.scrollTimeInMillis += stats.scrollTimeInMillis;
            this.scrollCurrent += stats.scrollCurrent;
            this.suggestCount += stats.suggestCount;
            this.suggestTimeInMillis += stats.suggestTimeInMillis;
            this.suggestCurrent += stats.suggestCurrent;
            this.recentSearchLoad += stats.recentSearchLoad;
        }

        public void addForClosingShard(Stats stats) {
            this.queryCount += stats.queryCount;
            this.queryTimeInMillis += stats.queryTimeInMillis;
            this.queryFailure += stats.queryFailure;
            this.fetchCount += stats.fetchCount;
            this.fetchTimeInMillis += stats.fetchTimeInMillis;
            this.fetchFailure += stats.fetchFailure;
            this.scrollCount += stats.scrollCount;
            this.scrollTimeInMillis += stats.scrollTimeInMillis;
            this.scrollCount += stats.scrollCurrent;
            this.suggestCount += stats.suggestCount;
            this.suggestTimeInMillis += stats.suggestTimeInMillis;
            this.recentSearchLoad += stats.recentSearchLoad;
        }

        public long getQueryCount() {
            return this.queryCount;
        }

        public TimeValue getQueryTime() {
            return new TimeValue(this.queryTimeInMillis);
        }

        public long getQueryTimeInMillis() {
            return this.queryTimeInMillis;
        }

        public long getQueryCurrent() {
            return this.queryCurrent;
        }

        public long getQueryFailure() {
            return this.queryFailure;
        }

        public long getFetchCount() {
            return this.fetchCount;
        }

        public TimeValue getFetchTime() {
            return new TimeValue(this.fetchTimeInMillis);
        }

        public long getFetchTimeInMillis() {
            return this.fetchTimeInMillis;
        }

        public long getFetchCurrent() {
            return this.fetchCurrent;
        }

        public long getFetchFailure() {
            return this.fetchFailure;
        }

        public long getScrollCount() {
            return this.scrollCount;
        }

        public TimeValue getScrollTime() {
            return new TimeValue(this.scrollTimeInMillis);
        }

        public long getScrollTimeInMillis() {
            return this.scrollTimeInMillis;
        }

        public long getScrollCurrent() {
            return this.scrollCurrent;
        }

        public long getSuggestCount() {
            return this.suggestCount;
        }

        public long getSuggestTimeInMillis() {
            return this.suggestTimeInMillis;
        }

        public TimeValue getSuggestTime() {
            return new TimeValue(this.suggestTimeInMillis);
        }

        public long getSuggestCurrent() {
            return this.suggestCurrent;
        }

        public double getSearchLoadRate() {
            return this.recentSearchLoad;
        }

        public static Stats readStats(StreamInput in) throws IOException {
            return new Stats(in);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("query_total", this.queryCount);
            builder.humanReadableField("query_time_in_millis", "query_time", (Object)this.getQueryTime());
            builder.field("query_current", this.queryCurrent);
            builder.field("query_failure", this.queryFailure);
            builder.field("fetch_total", this.fetchCount);
            builder.humanReadableField("fetch_time_in_millis", "fetch_time", (Object)this.getFetchTime());
            builder.field("fetch_current", this.fetchCurrent);
            builder.field("fetch_failure", this.fetchFailure);
            builder.field("scroll_total", this.scrollCount);
            builder.humanReadableField("scroll_time_in_millis", "scroll_time", (Object)this.getScrollTime());
            builder.field("scroll_current", this.scrollCurrent);
            builder.field("suggest_total", this.suggestCount);
            builder.humanReadableField("suggest_time_in_millis", "suggest_time", (Object)this.getSuggestTime());
            builder.field("suggest_current", this.suggestCurrent);
            builder.field("recent_search_load", this.recentSearchLoad);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats that = (Stats)o;
            return this.queryCount == that.queryCount && this.queryTimeInMillis == that.queryTimeInMillis && this.queryCurrent == that.queryCurrent && this.queryFailure == that.queryFailure && this.fetchCount == that.fetchCount && this.fetchTimeInMillis == that.fetchTimeInMillis && this.fetchCurrent == that.fetchCurrent && this.fetchFailure == that.fetchFailure && this.scrollCount == that.scrollCount && this.scrollTimeInMillis == that.scrollTimeInMillis && this.scrollCurrent == that.scrollCurrent && this.suggestCount == that.suggestCount && this.suggestTimeInMillis == that.suggestTimeInMillis && this.suggestCurrent == that.suggestCurrent && this.recentSearchLoad == that.recentSearchLoad;
        }

        public int hashCode() {
            return Objects.hash(this.queryCount, this.queryTimeInMillis, this.queryCurrent, this.queryFailure, this.fetchCount, this.fetchTimeInMillis, this.fetchCurrent, this.fetchCount, this.scrollCount, this.scrollTimeInMillis, this.scrollCurrent, this.suggestCount, this.suggestTimeInMillis, this.suggestCurrent, this.recentSearchLoad);
        }
    }

    static final class Fields {
        static final String SEARCH = "search";
        static final String OPEN_CONTEXTS = "open_contexts";
        static final String GROUPS = "groups";
        static final String QUERY_TOTAL = "query_total";
        static final String QUERY_TIME = "query_time";
        static final String QUERY_TIME_IN_MILLIS = "query_time_in_millis";
        static final String QUERY_CURRENT = "query_current";
        static final String QUERY_FAILURE = "query_failure";
        static final String FETCH_TOTAL = "fetch_total";
        static final String FETCH_TIME = "fetch_time";
        static final String FETCH_TIME_IN_MILLIS = "fetch_time_in_millis";
        static final String FETCH_CURRENT = "fetch_current";
        static final String FETCH_FAILURE = "fetch_failure";
        static final String SCROLL_TOTAL = "scroll_total";
        static final String SCROLL_TIME = "scroll_time";
        static final String SCROLL_TIME_IN_MILLIS = "scroll_time_in_millis";
        static final String SCROLL_CURRENT = "scroll_current";
        static final String SUGGEST_TOTAL = "suggest_total";
        static final String SUGGEST_TIME = "suggest_time";
        static final String SUGGEST_TIME_IN_MILLIS = "suggest_time_in_millis";
        static final String SUGGEST_CURRENT = "suggest_current";
        static final String RECENT_SEARCH_LOAD = "recent_search_load";

        Fields() {
        }
    }
}

