/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.health;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;

public final class ClusterStateHealth
implements Writeable {
    private final int numberOfNodes;
    private final int numberOfDataNodes;
    private final int activeShards;
    private final int relocatingShards;
    private final int activePrimaryShards;
    private final int initializingShards;
    private final int unassignedShards;
    private final int unassignedPrimaryShards;
    private final double activeShardsPercent;
    private final ClusterHealthStatus status;
    private final Map<String, ClusterIndexHealth> indices;

    public ClusterStateHealth(ClusterState clusterState, String[] concreteAllIndices, ProjectId projectId) {
        this(clusterState.metadata().getProject(projectId), clusterState.routingTable(projectId), clusterState.nodes(), clusterState.blocks(), concreteAllIndices);
    }

    public ClusterStateHealth(ProjectMetadata project, RoutingTable routingTable, DiscoveryNodes nodes, ClusterBlocks blocks, String[] concreteIndices) {
        this.numberOfNodes = nodes.getSize();
        this.numberOfDataNodes = nodes.getDataNodes().size();
        this.indices = new HashMap<String, ClusterIndexHealth>();
        ClusterHealthStatus computeStatus = ClusterHealthStatus.GREEN;
        int computeActivePrimaryShards = 0;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedPrimaryShards = 0;
        int computeUnassignedShards = 0;
        int totalShardCount = 0;
        for (String index : concreteIndices) {
            IndexMetadata indexMetadata = project.index(index);
            if (indexMetadata == null) {
                assert (false) : "concrete index [" + index + "] not found in project [" + String.valueOf(project.id()) + "]";
                computeStatus = ClusterHealthStatus.RED;
                continue;
            }
            IndexRoutingTable indexRoutingTable = routingTable.index(index);
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(indexMetadata, indexRoutingTable);
            this.indices.put(indexHealth.getIndex(), indexHealth);
            totalShardCount += indexMetadata.getTotalNumberOfShards();
            computeActivePrimaryShards += indexHealth.getActivePrimaryShards();
            computeActiveShards += indexHealth.getActiveShards();
            computeRelocatingShards += indexHealth.getRelocatingShards();
            computeInitializingShards += indexHealth.getInitializingShards();
            computeUnassignedShards += indexHealth.getUnassignedShards();
            computeUnassignedPrimaryShards += indexHealth.getUnassignedPrimaryShards();
            if (indexHealth.getStatus() == ClusterHealthStatus.RED) {
                computeStatus = ClusterHealthStatus.RED;
                continue;
            }
            if (indexHealth.getStatus() != ClusterHealthStatus.YELLOW || computeStatus == ClusterHealthStatus.RED) continue;
            computeStatus = ClusterHealthStatus.YELLOW;
        }
        if (blocks.hasGlobalBlockWithStatus(RestStatus.SERVICE_UNAVAILABLE)) {
            computeStatus = ClusterHealthStatus.RED;
        }
        this.status = computeStatus;
        this.activePrimaryShards = computeActivePrimaryShards;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
        this.unassignedPrimaryShards = computeUnassignedPrimaryShards;
        this.activeShardsPercent = computeStatus.equals(ClusterHealthStatus.GREEN) ? 100.0 : (double)this.activeShards / (double)totalShardCount * 100.0;
    }

    public ClusterStateHealth(StreamInput in) throws IOException {
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.numberOfNodes = in.readVInt();
        this.numberOfDataNodes = in.readVInt();
        this.status = ClusterHealthStatus.readFrom(in);
        this.indices = in.readMapValues(ClusterIndexHealth::new, ClusterIndexHealth::getIndex);
        this.activeShardsPercent = in.readDouble();
        this.unassignedPrimaryShards = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? in.readVInt() : 0;
    }

    public ClusterStateHealth(int activePrimaryShards, int activeShards, int relocatingShards, int initializingShards, int unassignedShards, int unassignedPrimaryShards, int numberOfNodes, int numberOfDataNodes, double activeShardsPercent, ClusterHealthStatus status, Map<String, ClusterIndexHealth> indices) {
        this.activePrimaryShards = activePrimaryShards;
        this.activeShards = activeShards;
        this.relocatingShards = relocatingShards;
        this.initializingShards = initializingShards;
        this.unassignedShards = unassignedShards;
        this.unassignedPrimaryShards = unassignedPrimaryShards;
        this.numberOfNodes = numberOfNodes;
        this.numberOfDataNodes = numberOfDataNodes;
        this.activeShardsPercent = activeShardsPercent;
        this.status = status;
        this.indices = indices;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedPrimaryShards() {
        return this.unassignedPrimaryShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return Collections.unmodifiableMap(this.indices);
    }

    public double getActiveShardsPercent() {
        return this.activeShardsPercent;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeVInt(this.numberOfNodes);
        out.writeVInt(this.numberOfDataNodes);
        out.writeByte(this.status.value());
        out.writeMapValues(this.indices);
        out.writeDouble(this.activeShardsPercent);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            out.writeVInt(this.unassignedPrimaryShards);
        }
    }

    public String toString() {
        return "ClusterStateHealth{numberOfNodes=" + this.numberOfNodes + ", numberOfDataNodes=" + this.numberOfDataNodes + ", activeShards=" + this.activeShards + ", relocatingShards=" + this.relocatingShards + ", activePrimaryShards=" + this.activePrimaryShards + ", initializingShards=" + this.initializingShards + ", unassignedShards=" + this.unassignedShards + ", unassignedPrimaryShards=" + this.unassignedPrimaryShards + ", activeShardsPercent=" + this.activeShardsPercent + ", status=" + String.valueOf(this.status) + ", indices.size=" + String.valueOf(this.indices == null ? "null" : Integer.valueOf(this.indices.size())) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateHealth that = (ClusterStateHealth)o;
        return this.numberOfNodes == that.numberOfNodes && this.numberOfDataNodes == that.numberOfDataNodes && this.activeShards == that.activeShards && this.relocatingShards == that.relocatingShards && this.activePrimaryShards == that.activePrimaryShards && this.initializingShards == that.initializingShards && this.unassignedShards == that.unassignedShards && this.unassignedPrimaryShards == that.unassignedPrimaryShards && Double.compare(that.activeShardsPercent, this.activeShardsPercent) == 0 && this.status == that.status && Objects.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfNodes, this.numberOfDataNodes, this.activeShards, this.relocatingShards, this.activePrimaryShards, this.initializingShards, this.unassignedShards, this.unassignedPrimaryShards, this.activeShardsPercent, this.status, this.indices);
    }
}

