/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.health;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ClusterStatsLevel;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class ClusterIndexHealth
implements Writeable,
ToXContentFragment {
    static final String STATUS = "status";
    static final String NUMBER_OF_SHARDS = "number_of_shards";
    static final String NUMBER_OF_REPLICAS = "number_of_replicas";
    static final String ACTIVE_PRIMARY_SHARDS = "active_primary_shards";
    static final String ACTIVE_SHARDS = "active_shards";
    static final String RELOCATING_SHARDS = "relocating_shards";
    static final String INITIALIZING_SHARDS = "initializing_shards";
    static final String UNASSIGNED_SHARDS = "unassigned_shards";
    static final String UNASSIGNED_PRIMARY_SHARDS = "unassigned_primary_shards";
    static final String SHARDS = "shards";
    private final String index;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final int activeShards;
    private final int relocatingShards;
    private final int initializingShards;
    private final int unassignedShards;
    private final int unassignedPrimaryShards;
    private final int activePrimaryShards;
    private final ClusterHealthStatus status;
    private final Map<Integer, ClusterShardHealth> shards;

    public ClusterIndexHealth(IndexMetadata indexMetadata, IndexRoutingTable indexRoutingTable) {
        this.index = indexMetadata.getIndex().getName();
        this.numberOfShards = indexMetadata.getNumberOfShards();
        this.numberOfReplicas = indexMetadata.getNumberOfReplicas();
        this.shards = new HashMap<Integer, ClusterShardHealth>();
        if (indexRoutingTable != null) {
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(i);
                int shardId = shardRoutingTable.shardId().id();
                this.shards.put(shardId, new ClusterShardHealth(shardId, shardRoutingTable));
            }
        } else {
            for (int shardId = 0; shardId < this.numberOfShards; ++shardId) {
                int replicasCount = this.numberOfReplicas + 1;
                ClusterShardHealth clusterShardHealth = new ClusterShardHealth(shardId, ClusterHealthStatus.RED, 0, 0, 0, replicasCount, 1, false);
                this.shards.put(shardId, clusterShardHealth);
            }
        }
        ClusterHealthStatus computeStatus = ClusterHealthStatus.GREEN;
        int computeActivePrimaryShards = 0;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedPrimaryShards = 0;
        int computeUnassignedShards = 0;
        for (ClusterShardHealth shardHealth : this.shards.values()) {
            if (shardHealth.isPrimaryActive()) {
                ++computeActivePrimaryShards;
            }
            computeActiveShards += shardHealth.getActiveShards();
            computeRelocatingShards += shardHealth.getRelocatingShards();
            computeInitializingShards += shardHealth.getInitializingShards();
            computeUnassignedShards += shardHealth.getUnassignedShards();
            computeUnassignedPrimaryShards += shardHealth.getUnassignedPrimaryShards();
            if (shardHealth.getStatus() == ClusterHealthStatus.RED) {
                computeStatus = ClusterHealthStatus.RED;
                continue;
            }
            if (shardHealth.getStatus() != ClusterHealthStatus.YELLOW || computeStatus == ClusterHealthStatus.RED) continue;
            computeStatus = ClusterHealthStatus.YELLOW;
        }
        if (this.shards.isEmpty()) {
            computeStatus = ClusterHealthStatus.RED;
        }
        this.status = computeStatus;
        this.activePrimaryShards = computeActivePrimaryShards;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
        this.unassignedPrimaryShards = computeUnassignedPrimaryShards;
    }

    public ClusterIndexHealth(StreamInput in) throws IOException {
        this.index = in.readString();
        this.numberOfShards = in.readVInt();
        this.numberOfReplicas = in.readVInt();
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.status = ClusterHealthStatus.readFrom(in);
        this.shards = in.readMapValues(ClusterShardHealth::new, ClusterShardHealth::getShardId);
        this.unassignedPrimaryShards = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? in.readVInt() : 0;
    }

    ClusterIndexHealth(String index, int numberOfShards, int numberOfReplicas, int activeShards, int relocatingShards, int initializingShards, int unassignedShards, int unassignedPrimaryShards, int activePrimaryShards, ClusterHealthStatus status, Map<Integer, ClusterShardHealth> shards) {
        this.index = index;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.activeShards = activeShards;
        this.relocatingShards = relocatingShards;
        this.initializingShards = initializingShards;
        this.unassignedShards = unassignedShards;
        this.unassignedPrimaryShards = unassignedPrimaryShards;
        this.activePrimaryShards = activePrimaryShards;
        this.status = status;
        this.shards = shards;
    }

    public String getIndex() {
        return this.index;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public int getUnassignedPrimaryShards() {
        return this.unassignedPrimaryShards;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<Integer, ClusterShardHealth> getShards() {
        return this.shards;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.numberOfShards);
        out.writeVInt(this.numberOfReplicas);
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeByte(this.status.value());
        out.writeMapValues(this.shards);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            out.writeVInt(this.unassignedPrimaryShards);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getIndex());
        builder.field(STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(NUMBER_OF_SHARDS, this.getNumberOfShards());
        builder.field(NUMBER_OF_REPLICAS, this.getNumberOfReplicas());
        builder.field(ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(ACTIVE_SHARDS, this.getActiveShards());
        builder.field(RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(UNASSIGNED_SHARDS, this.getUnassignedShards());
        builder.field(UNASSIGNED_PRIMARY_SHARDS, this.getUnassignedPrimaryShards());
        ClusterStatsLevel level = ClusterStatsLevel.of(params, ClusterStatsLevel.INDICES);
        if (level == ClusterStatsLevel.SHARDS) {
            builder.startObject(SHARDS);
            for (ClusterShardHealth shardHealth : this.shards.values()) {
                shardHealth.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "ClusterIndexHealth{index='" + this.index + "', numberOfShards=" + this.numberOfShards + ", numberOfReplicas=" + this.numberOfReplicas + ", activeShards=" + this.activeShards + ", relocatingShards=" + this.relocatingShards + ", initializingShards=" + this.initializingShards + ", unassignedShards=" + this.unassignedShards + ", unassignedPrimaryShards=" + this.unassignedPrimaryShards + ", activePrimaryShards=" + this.activePrimaryShards + ", status=" + String.valueOf(this.status) + ", shards.size=" + String.valueOf(this.shards == null ? "null" : Integer.valueOf(this.shards.size())) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterIndexHealth that = (ClusterIndexHealth)o;
        return Objects.equals(this.index, that.index) && this.numberOfShards == that.numberOfShards && this.numberOfReplicas == that.numberOfReplicas && this.activeShards == that.activeShards && this.relocatingShards == that.relocatingShards && this.initializingShards == that.initializingShards && this.unassignedShards == that.unassignedShards && this.unassignedPrimaryShards == that.unassignedPrimaryShards && this.activePrimaryShards == that.activePrimaryShards && this.status == that.status && Objects.equals(this.shards, that.shards);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.numberOfShards, this.numberOfReplicas, this.activeShards, this.relocatingShards, this.initializingShards, this.unassignedShards, this.unassignedPrimaryShards, this.activePrimaryShards, this.status, this.shards);
    }
}

