/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MultiGetResponse
extends ActionResponse
implements Iterable<MultiGetItemResponse>,
ToXContentObject {
    static final ParseField INDEX = new ParseField("_index", new String[0]);
    static final ParseField ID = new ParseField("_id", new String[0]);
    static final ParseField DOCS = new ParseField("docs", new String[0]);
    private final MultiGetItemResponse[] responses;

    public MultiGetResponse(MultiGetItemResponse[] responses) {
        this.responses = responses;
    }

    public MultiGetItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public Iterator<MultiGetItemResponse> iterator() {
        return Iterators.forArray(this.responses);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(DOCS.getPreferredName());
        for (MultiGetItemResponse response : this.responses) {
            if (response.isFailed()) {
                Failure failure = response.getFailure();
                failure.toXContent(builder, params);
                continue;
            }
            GetResponse getResponse = response.getResponse();
            getResponse.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.responses);
    }

    public static class Failure
    implements Writeable,
    ToXContentObject {
        private final String index;
        private final String id;
        private final Exception exception;

        public Failure(String index, String id, Exception exception) {
            this.index = index;
            this.id = id;
            this.exception = exception;
        }

        Failure(StreamInput in) throws IOException {
            this.index = in.readString();
            this.id = in.readString();
            this.exception = in.readException();
        }

        public String getIndex() {
            return this.index;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.exception != null ? this.exception.getMessage() : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeString(this.id);
            out.writeException(this.exception);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX.getPreferredName(), this.index);
            builder.field(ID.getPreferredName(), this.id);
            ElasticsearchException.generateFailureXContent(builder, params, this.exception, true);
            builder.endObject();
            return builder;
        }

        public Exception getFailure() {
            return this.exception;
        }
    }
}

