/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ShardStats
implements Writeable,
ToXContentFragment {
    private final ShardRouting shardRouting;
    private final CommonStats commonStats;
    @Nullable
    private final CommitStats commitStats;
    @Nullable
    private final SeqNoStats seqNoStats;
    @Nullable
    private final RetentionLeaseStats retentionLeaseStats;
    private final String dataPath;
    private final String statePath;
    private final boolean isCustomDataPath;
    private final boolean isSearchIdle;
    private final long searchIdleTime;

    public ShardStats(StreamInput in) throws IOException {
        assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
        this.shardRouting = new ShardRouting(in);
        this.commonStats = new CommonStats(in);
        this.commitStats = CommitStats.readOptionalCommitStatsFrom(in);
        this.statePath = in.readString();
        this.dataPath = Objects.requireNonNullElse(in.readOptionalString(), this.statePath);
        this.isCustomDataPath = in.readBoolean();
        this.seqNoStats = in.readOptionalWriteable(SeqNoStats::new);
        this.retentionLeaseStats = in.readOptionalWriteable(RetentionLeaseStats::new);
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            this.isSearchIdle = in.readBoolean();
            this.searchIdleTime = in.readVLong();
        } else {
            this.isSearchIdle = false;
            this.searchIdleTime = 0L;
        }
    }

    public ShardStats(ShardRouting shardRouting, CommonStats commonStats, CommitStats commitStats, SeqNoStats seqNoStats, RetentionLeaseStats retentionLeaseStats, String dataPath, String statePath, boolean isCustomDataPath, boolean isSearchIdle, long searchIdleTime) {
        this.shardRouting = shardRouting;
        this.commonStats = commonStats;
        this.commitStats = commitStats;
        this.seqNoStats = seqNoStats;
        this.retentionLeaseStats = retentionLeaseStats;
        this.dataPath = dataPath;
        this.statePath = statePath;
        this.isCustomDataPath = isCustomDataPath;
        this.isSearchIdle = isSearchIdle;
        this.searchIdleTime = searchIdleTime;
    }

    public ShardStats(ShardRouting shardRouting, ShardPath shardPath, CommonStats commonStats, CommitStats commitStats, SeqNoStats seqNoStats, RetentionLeaseStats retentionLeaseStats, boolean isSearchIdle, long searchIdleTime) {
        this(shardRouting, commonStats, commitStats, seqNoStats, retentionLeaseStats, shardPath.getRootDataPath().toString(), shardPath.getRootStatePath().toString(), shardPath.isCustomDataPath(), isSearchIdle, searchIdleTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStats that = (ShardStats)o;
        return Objects.equals(this.shardRouting, that.shardRouting) && Objects.equals(this.dataPath, that.dataPath) && Objects.equals(this.statePath, that.statePath) && this.isCustomDataPath == that.isCustomDataPath && Objects.equals(this.commitStats, that.commitStats) && Objects.equals(this.commonStats, that.commonStats) && Objects.equals(this.seqNoStats, that.seqNoStats) && Objects.equals(this.retentionLeaseStats, that.retentionLeaseStats) && Objects.equals(this.isSearchIdle, that.isSearchIdle) && Objects.equals(this.searchIdleTime, that.searchIdleTime);
    }

    public int hashCode() {
        return Objects.hash(this.shardRouting, this.dataPath, this.statePath, this.isCustomDataPath, this.commitStats, this.commonStats, this.seqNoStats, this.retentionLeaseStats, this.isSearchIdle, this.searchIdleTime);
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public CommonStats getStats() {
        return this.commonStats;
    }

    @Nullable
    public CommitStats getCommitStats() {
        return this.commitStats;
    }

    @Nullable
    public SeqNoStats getSeqNoStats() {
        return this.seqNoStats;
    }

    public RetentionLeaseStats getRetentionLeaseStats() {
        return this.retentionLeaseStats;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getStatePath() {
        return this.statePath;
    }

    public boolean isCustomDataPath() {
        return this.isCustomDataPath;
    }

    public boolean isSearchIdle() {
        return this.isSearchIdle;
    }

    public long getSearchIdleTime() {
        return this.searchIdleTime;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        this.commonStats.writeTo(out);
        out.writeOptionalWriteable(this.commitStats);
        out.writeString(this.statePath);
        out.writeOptionalString(this.statePath.equals(this.dataPath) ? null : this.dataPath);
        out.writeBoolean(this.isCustomDataPath);
        out.writeOptionalWriteable(this.seqNoStats);
        out.writeOptionalWriteable(this.retentionLeaseStats);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeBoolean(this.isSearchIdle);
            out.writeVLong(this.searchIdleTime);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("routing").field("state", (Enum)this.shardRouting.state()).field("primary", this.shardRouting.primary()).field("node", this.shardRouting.currentNodeId()).field("relocating_node", this.shardRouting.relocatingNodeId()).endObject();
        this.commonStats.toXContent(builder, params);
        if (this.commitStats != null) {
            this.commitStats.toXContent(builder, params);
        }
        if (this.seqNoStats != null) {
            this.seqNoStats.toXContent(builder, params);
        }
        if (this.retentionLeaseStats != null) {
            this.retentionLeaseStats.toXContent(builder, params);
        }
        builder.startObject("shard_path");
        builder.field("state_path", this.statePath);
        builder.field("data_path", this.dataPath);
        builder.field("is_custom_data_path", this.isCustomDataPath);
        builder.endObject();
        builder.field("search_idle", this.isSearchIdle);
        builder.field("search_idle_time", this.searchIdleTime);
        return builder;
    }

    static final class Fields {
        static final String ROUTING = "routing";
        static final String STATE = "state";
        static final String STATE_PATH = "state_path";
        static final String DATA_PATH = "data_path";
        static final String IS_CUSTOM_DATA_PATH = "is_custom_data_path";
        static final String SHARD_PATH = "shard_path";
        static final String PRIMARY = "primary";
        static final String NODE = "node";
        static final String RELOCATING_NODE = "relocating_node";
        static final String SEARCH_IDLE = "search_idle";
        static final String SEARCH_IDLE_TIME = "search_idle_time";

        Fields() {
        }
    }
}

