/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.segments;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class IndicesSegmentsRequest
extends BroadcastRequest<IndicesSegmentsRequest> {
    private boolean includeVectorFormatsInfo;

    public IndicesSegmentsRequest() {
        this(Strings.EMPTY_ARRAY);
    }

    public IndicesSegmentsRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
            this.includeVectorFormatsInfo = in.readBoolean();
        }
    }

    public IndicesSegmentsRequest(String ... indices) {
        super(indices);
        this.includeVectorFormatsInfo = false;
    }

    public IndicesSegmentsRequest withVectorFormatsInfo(boolean includeVectorFormatsInfo) {
        this.includeVectorFormatsInfo = includeVectorFormatsInfo;
        return this;
    }

    public boolean isIncludeVectorFormatsInfo() {
        return this.includeVectorFormatsInfo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
            out.writeBoolean(this.includeVectorFormatsInfo);
        }
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }
}

