/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class ClusterGetSettingsAction
extends ActionType<Response> {
    public static final ClusterGetSettingsAction INSTANCE = new ClusterGetSettingsAction();
    public static final String NAME = "cluster:monitor/settings";

    public ClusterGetSettingsAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse {
        private final Settings persistentSettings;
        private final Settings transientSettings;
        private final Settings settings;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.persistentSettings, response.persistentSettings) && Objects.equals(this.transientSettings, response.transientSettings) && Objects.equals(this.settings, response.settings);
        }

        public int hashCode() {
            return Objects.hash(this.persistentSettings, this.transientSettings, this.settings);
        }

        public Response(Settings persistentSettings, Settings transientSettings, Settings settings) {
            this.persistentSettings = Objects.requireNonNullElse(persistentSettings, Settings.EMPTY);
            this.transientSettings = Objects.requireNonNullElse(transientSettings, Settings.EMPTY);
            this.settings = Objects.requireNonNullElse(settings, Settings.EMPTY);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.persistentSettings.writeTo(out);
            this.transientSettings.writeTo(out);
            this.settings.writeTo(out);
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Settings settings() {
            return this.settings;
        }
    }

    public static class Request
    extends LocalClusterStateRequest {
        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }
    }
}

