/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.ingest.IngestInfo;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.search.aggregations.support.AggregationInfo;
import org.elasticsearch.threadpool.ThreadPoolInfo;
import org.elasticsearch.transport.RemoteClusterServerInfo;
import org.elasticsearch.transport.TransportInfo;

public class NodeInfo
extends BaseNodeResponse {
    private final String version;
    private final CompatibilityVersions compatibilityVersions;
    private final IndexVersion indexVersion;
    private final Map<String, Integer> componentVersions;
    private final Build build;
    @Nullable
    private final Settings settings;
    private final Map<Class<? extends ReportingService.Info>, ReportingService.Info> infoMap = new HashMap<Class<? extends ReportingService.Info>, ReportingService.Info>();
    @Nullable
    private final ByteSizeValue totalIndexingBuffer;

    public NodeInfo(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            this.version = in.readString();
            this.compatibilityVersions = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_1) ? CompatibilityVersions.readVersion(in) : new CompatibilityVersions(TransportVersion.readVersion(in), Map.of());
            this.indexVersion = IndexVersion.readVersion(in);
        } else {
            Version legacyVersion = Version.readVersion(in);
            this.version = legacyVersion.toString();
            this.compatibilityVersions = new CompatibilityVersions(TransportVersion.readVersion(in), Map.of());
            this.indexVersion = in.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X) ? IndexVersion.readVersion(in) : IndexVersion.fromId(legacyVersion.id);
        }
        this.componentVersions = in.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X) ? in.readImmutableMap(StreamInput::readString, StreamInput::readVInt) : Map.of();
        this.build = Build.readBuild(in);
        this.totalIndexingBuffer = in.readBoolean() ? ByteSizeValue.ofBytes(in.readLong()) : null;
        this.settings = in.readBoolean() ? Settings.readSettingsFromStream(in) : null;
        this.addInfoIfNonNull(OsInfo.class, in.readOptionalWriteable(OsInfo::new));
        this.addInfoIfNonNull(ProcessInfo.class, in.readOptionalWriteable(ProcessInfo::new));
        this.addInfoIfNonNull(JvmInfo.class, in.readOptionalWriteable(JvmInfo::new));
        this.addInfoIfNonNull(ThreadPoolInfo.class, in.readOptionalWriteable(ThreadPoolInfo::new));
        this.addInfoIfNonNull(TransportInfo.class, in.readOptionalWriteable(TransportInfo::new));
        this.addInfoIfNonNull(HttpInfo.class, in.readOptionalWriteable(HttpInfo::new));
        this.addInfoIfNonNull(PluginsAndModules.class, in.readOptionalWriteable(PluginsAndModules::new));
        this.addInfoIfNonNull(IngestInfo.class, in.readOptionalWriteable(IngestInfo::new));
        this.addInfoIfNonNull(AggregationInfo.class, in.readOptionalWriteable(AggregationInfo::new));
        this.addInfoIfNonNull(RemoteClusterServerInfo.class, in.readOptionalWriteable(RemoteClusterServerInfo::new));
    }

    public NodeInfo(String version, CompatibilityVersions compatibilityVersions, IndexVersion indexVersion, Map<String, Integer> componentVersions, Build build, DiscoveryNode node, @Nullable Settings settings, @Nullable OsInfo os, @Nullable ProcessInfo process, @Nullable JvmInfo jvm, @Nullable ThreadPoolInfo threadPool, @Nullable TransportInfo transport, @Nullable HttpInfo http, @Nullable RemoteClusterServerInfo remoteClusterServer, @Nullable PluginsAndModules plugins, @Nullable IngestInfo ingest, @Nullable AggregationInfo aggsInfo, @Nullable ByteSizeValue totalIndexingBuffer) {
        super(node);
        this.version = version;
        this.compatibilityVersions = compatibilityVersions;
        this.indexVersion = indexVersion;
        this.componentVersions = componentVersions;
        this.build = build;
        this.settings = settings;
        this.addInfoIfNonNull(OsInfo.class, os);
        this.addInfoIfNonNull(ProcessInfo.class, process);
        this.addInfoIfNonNull(JvmInfo.class, jvm);
        this.addInfoIfNonNull(ThreadPoolInfo.class, threadPool);
        this.addInfoIfNonNull(TransportInfo.class, transport);
        this.addInfoIfNonNull(HttpInfo.class, http);
        this.addInfoIfNonNull(RemoteClusterServerInfo.class, remoteClusterServer);
        this.addInfoIfNonNull(PluginsAndModules.class, plugins);
        this.addInfoIfNonNull(IngestInfo.class, ingest);
        this.addInfoIfNonNull(AggregationInfo.class, aggsInfo);
        this.totalIndexingBuffer = totalIndexingBuffer;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    public String getVersion() {
        return this.version;
    }

    public TransportVersion getTransportVersion() {
        return this.compatibilityVersions.transportVersion();
    }

    public IndexVersion getIndexVersion() {
        return this.indexVersion;
    }

    public Map<String, Integer> getComponentVersions() {
        return this.componentVersions;
    }

    public Map<String, SystemIndexDescriptor.MappingsVersion> getCompatibilityVersions() {
        return this.compatibilityVersions.systemIndexMappingsVersion();
    }

    public Build getBuild() {
        return this.build;
    }

    @Nullable
    public Settings getSettings() {
        return this.settings;
    }

    public <T extends ReportingService.Info> T getInfo(Class<T> clazz) {
        return (T)((ReportingService.Info)clazz.cast(this.infoMap.get(clazz)));
    }

    @Nullable
    public ByteSizeValue getTotalIndexingBuffer() {
        return this.totalIndexingBuffer;
    }

    private <T extends ReportingService.Info> void addInfoIfNonNull(Class<T> clazz, T info) {
        if (info != null) {
            this.infoMap.put(clazz, info);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeString(this.version);
        } else {
            Version.writeVersion(Version.fromString(this.version), out);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_1)) {
            this.compatibilityVersions.writeTo(out);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
            IndexVersion.writeVersion(this.indexVersion, out);
            out.writeMap(this.componentVersions, StreamOutput::writeString, StreamOutput::writeVInt);
        }
        Build.writeBuild(this.build, out);
        if (this.totalIndexingBuffer == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.totalIndexingBuffer.getBytes());
        }
        if (this.settings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.settings.writeTo(out);
        }
        out.writeOptionalWriteable(this.getInfo(OsInfo.class));
        out.writeOptionalWriteable(this.getInfo(ProcessInfo.class));
        out.writeOptionalWriteable(this.getInfo(JvmInfo.class));
        out.writeOptionalWriteable(this.getInfo(ThreadPoolInfo.class));
        out.writeOptionalWriteable(this.getInfo(TransportInfo.class));
        out.writeOptionalWriteable(this.getInfo(HttpInfo.class));
        out.writeOptionalWriteable(this.getInfo(PluginsAndModules.class));
        out.writeOptionalWriteable(this.getInfo(IngestInfo.class));
        out.writeOptionalWriteable(this.getInfo(AggregationInfo.class));
        out.writeOptionalWriteable(this.getInfo(RemoteClusterServerInfo.class));
    }
}

