/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.data.TDigestBlockBuilder;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

public class ResultBuilderForTDigest
implements ResultBuilder {
    private final TDigestBlockBuilder builder;
    private final ReusableTopNEncoderInput reusableInput = new ReusableTopNEncoderInput();

    ResultBuilderForTDigest(BlockFactory blockFactory, int positions) {
        this.builder = blockFactory.newTDigestBlockBuilder(positions);
    }

    @Override
    public void decodeKey(BytesRef keys) {
        throw new AssertionError((Object)"TDigest can't be a key");
    }

    @Override
    public void decodeValue(BytesRef values) {
        int count = TopNEncoder.DEFAULT_UNSORTABLE.decodeVInt(values);
        if (count == 0) {
            this.builder.appendNull();
            return;
        }
        assert (count == 1) : "TDigest does not support multi values";
        this.reusableInput.inputValues = values;
        this.builder.deserializeAndAppend(this.reusableInput);
    }

    @Override
    public Block build() {
        return this.builder.build();
    }

    public String toString() {
        return "ResultBuilderForExponentialHistogram";
    }

    public void close() {
        this.builder.close();
    }

    private static final class ReusableTopNEncoderInput
    implements TDigestBlock.SerializedTDigestInput {
        BytesRef inputValues;

        private ReusableTopNEncoderInput() {
        }

        @Override
        public double readDouble() {
            return TopNEncoder.DEFAULT_UNSORTABLE.decodeDouble(this.inputValues);
        }

        @Override
        public long readLong() {
            return TopNEncoder.DEFAULT_UNSORTABLE.decodeLong(this.inputValues);
        }

        @Override
        public BytesRef readBytesRef(BytesRef scratch) {
            return TopNEncoder.DEFAULT_UNSORTABLE.decodeBytesRef(this.inputValues, scratch);
        }
    }
}

