/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.user;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.admin.cluster.shards.TransportClusterSearchShardsAction;
import org.elasticsearch.action.admin.indices.analyze.TransportReloadAnalyzersAction;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.admin.indices.readonly.TransportAddIndexBlockAction;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.search.TransportSearchScrollAction;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;

public class InternalUsers {
    public static final InternalUser ASYNC_SEARCH_USER = new InternalUser("_async_search", new RoleDescriptor("_async_search", new String[]{"cancel_task"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".async-search*").privileges("all").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null));
    public static final InternalUser SECURITY_PROFILE_USER = new InternalUser("_security_profile", new RoleDescriptor("_security_profile", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".security-profile", "/\\.security-profile-[0-9].*/").privileges("all").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final InternalUser STORAGE_USER = new InternalUser("_storage", new RoleDescriptor("_storage", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("indices:admin/refresh*").allowRestrictedIndices(true).build()}, new String[0], MetadataUtils.DEFAULT_RESERVED_METADATA));
    public static final InternalUser XPACK_USER = new InternalUser("_xpack", new RoleDescriptor("_xpack", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("/@&~(\\.security.*)&~(\\.async-search.*)/").privileges("all").allowRestrictedIndices(true).build()}, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA));
    public static final InternalUser XPACK_SECURITY_USER = new InternalUser("_xpack_security", new RoleDescriptor("_xpack_security", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("all").allowRestrictedIndices(true).build()}, null, null, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final InternalUser DATA_STREAM_LIFECYCLE_USER = new InternalUser("_data_stream_lifecycle", new RoleDescriptor("_data_stream_lifecycle", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges(InternalUsers.filterNonNull("manage_failure_store", "delete_index", "indices:admin/rollover", "indices:admin/forcemerge*", "indices:monitor/stats*", TransportUpdateSettingsAction.TYPE.name(), "indices:admin/xpack/downsample", TransportAddIndexBlockAction.TYPE.name())).allowRestrictedIndices(false).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".fleet-actions-results", ".fleet-fileds*").privileges(InternalUsers.filterNonNull("manage_failure_store", "delete_index", "indices:admin/rollover", "indices:admin/forcemerge*", "indices:monitor/stats*", TransportUpdateSettingsAction.TYPE.name(), "indices:admin/xpack/downsample", TransportAddIndexBlockAction.TYPE.name())).allowRestrictedIndices(true).build()}, null, null, new String[0], MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final InternalUser REINDEX_DATA_STREAM_USER = new InternalUser("_reindex_data_stream", new RoleDescriptor("_reindex_data_stream", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("indices:admin/data_stream/get", "indices:admin/rollover", "indices:monitor/stats", TransportDeleteIndexAction.TYPE.name(), "indices:admin/data_stream/index/reindex", "indices:admin/index/create_from_source", "indices:admin/index/copy_lifecycle_index_metadata", TransportAddIndexBlockAction.TYPE.name(), "indices:admin/open", "indices:admin/close", TransportCreateIndexAction.TYPE.name(), TransportClusterSearchShardsAction.TYPE.name(), "indices:monitor/settings/get", TransportUpdateSettingsAction.TYPE.name(), "indices:admin/refresh", "indices:data/write/reindex", "indices:data/read/search", "indices:data/write/bulk", "indices:data/write/index", TransportSearchScrollAction.TYPE.name(), "indices:admin/data_stream/modify", ILMActions.RETRY.name()).allowRestrictedIndices(true).build()}, null, null, new String[0], MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final InternalUser LAZY_ROLLOVER_USER = new InternalUser("_lazy_rollover", new RoleDescriptor("_lazy_rollover", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges(InternalUsers.filterNonNull("manage_failure_store", "indices:admin/data_stream/lazy_rollover")).allowRestrictedIndices(true).build()}, null, null, new String[0], MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final InternalUser SYNONYMS_USER = new InternalUser("_synonyms", new RoleDescriptor("_synonyms", new String[]{"monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".synonyms*").privileges("all").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges(TransportReloadAnalyzersAction.TYPE.name()).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final InternalUser CROSS_PROJECT_SEARCH_USER = new InternalUser("_cross_project_search", new RoleDescriptor("_cross_project_search", new String[]{"cluster:internal/remote_cluster/handshake", "cluster:internal/admin/tasks/ban", "cluster:internal/admin/tasks/cancel_child", "cluster:internal:data/read/esql/open_exchange", "cluster:internal:data/read/esql/exchange", "cluster:internal/remote_cluster/nodes"}, null, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final SystemUser SYSTEM_USER = SystemUser.INSTANCE;
    private static final Map<String, InternalUser> INTERNAL_USERS = Stream.of(SYSTEM_USER, XPACK_USER, XPACK_SECURITY_USER, SECURITY_PROFILE_USER, ASYNC_SEARCH_USER, STORAGE_USER, DATA_STREAM_LIFECYCLE_USER, REINDEX_DATA_STREAM_USER, SYNONYMS_USER, LAZY_ROLLOVER_USER, CROSS_PROJECT_SEARCH_USER).collect(Collectors.toUnmodifiableMap(User::principal, Function.identity()));

    public static Collection<InternalUser> get() {
        return Collections.unmodifiableCollection(INTERNAL_USERS.values());
    }

    public static InternalUser getUser(String username) {
        InternalUser instance = INTERNAL_USERS.get(username);
        if (instance == null) {
            throw new IllegalStateException("user [" + username + "] is not internal");
        }
        return instance;
    }

    private static String[] filterNonNull(String ... privileges) {
        return (String[])Arrays.stream(privileges).filter(Objects::nonNull).toArray(String[]::new);
    }
}

