/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.graph;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.protocol.xpack.graph.GraphExploreRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class VertexRequest
implements ToXContentObject,
Writeable {
    public static final int DEFAULT_SIZE = 5;
    public static final int DEFAULT_MIN_DOC_COUNT = 3;
    public static final int DEFAULT_SHARD_MIN_DOC_COUNT = 2;
    private String fieldName;
    private int size = 5;
    private Map<String, GraphExploreRequest.TermBoost> includes;
    private Set<String> excludes;
    private int minDocCount = 3;
    private int shardMinDocCount = 2;

    void readFrom(StreamInput in) throws IOException {
        int numExcludes;
        this.fieldName = in.readString();
        this.size = in.readVInt();
        this.minDocCount = in.readVInt();
        this.shardMinDocCount = in.readVInt();
        int numIncludes = in.readVInt();
        if (numIncludes > 0) {
            this.includes = new HashMap<String, GraphExploreRequest.TermBoost>();
            for (int i = 0; i < numIncludes; ++i) {
                GraphExploreRequest.TermBoost tb = new GraphExploreRequest.TermBoost();
                tb.readFrom(in);
                this.includes.put(tb.term, tb);
            }
        }
        if ((numExcludes = in.readVInt()) > 0) {
            this.excludes = new HashSet<String>();
            for (int i = 0; i < numExcludes; ++i) {
                this.excludes.add(in.readString());
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeVInt(this.size);
        out.writeVInt(this.minDocCount);
        out.writeVInt(this.shardMinDocCount);
        if (this.includes != null) {
            out.writeCollection(this.includes.values());
        } else {
            out.writeVInt(0);
        }
        if (this.excludes != null) {
            out.writeStringCollection(this.excludes);
        } else {
            out.writeVInt(0);
        }
    }

    public String fieldName() {
        return this.fieldName;
    }

    public VertexRequest fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public int size() {
        return this.size;
    }

    public VertexRequest size(int size) {
        this.size = size;
        return this;
    }

    public boolean hasIncludeClauses() {
        return this.includes != null && this.includes.size() > 0;
    }

    public boolean hasExcludeClauses() {
        return this.excludes != null && this.excludes.size() > 0;
    }

    public void addExclude(String term) {
        if (this.includes != null) {
            throw new IllegalArgumentException("Cannot have both include and exclude clauses");
        }
        if (this.excludes == null) {
            this.excludes = new HashSet<String>();
        }
        this.excludes.add(term);
    }

    public void addInclude(String term, float boost) {
        if (this.excludes != null) {
            throw new IllegalArgumentException("Cannot have both include and exclude clauses");
        }
        if (this.includes == null) {
            this.includes = new HashMap<String, GraphExploreRequest.TermBoost>();
        }
        this.includes.put(term, new GraphExploreRequest.TermBoost(term, boost));
    }

    public GraphExploreRequest.TermBoost[] includeValues() {
        return this.includes.values().toArray(new GraphExploreRequest.TermBoost[this.includes.size()]);
    }

    public SortedSet<BytesRef> includeValuesAsSortedSet() {
        TreeSet<BytesRef> set = new TreeSet<BytesRef>();
        for (String include : this.includes.keySet()) {
            set.add(new BytesRef((CharSequence)include));
        }
        return set;
    }

    public SortedSet<BytesRef> excludesAsSortedSet() {
        TreeSet<BytesRef> set = new TreeSet<BytesRef>();
        for (String include : this.excludes) {
            set.add(new BytesRef((CharSequence)include));
        }
        return set;
    }

    public int minDocCount() {
        return this.minDocCount;
    }

    public VertexRequest minDocCount(int value) {
        this.minDocCount = value;
        return this;
    }

    public int shardMinDocCount() {
        return Math.min(this.shardMinDocCount, this.minDocCount);
    }

    public VertexRequest shardMinDocCount(int value) {
        this.shardMinDocCount = value;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("field", this.fieldName);
        if (this.size != 5) {
            builder.field("size", this.size);
        }
        if (this.minDocCount != 3) {
            builder.field("min_doc_count", this.minDocCount);
        }
        if (this.shardMinDocCount != 2) {
            builder.field("shard_min_doc_count", this.shardMinDocCount);
        }
        if (this.includes != null) {
            builder.startArray("include");
            for (GraphExploreRequest.TermBoost tb : this.includes.values()) {
                builder.startObject();
                builder.field("term", tb.term);
                builder.field("boost", tb.boost);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.excludes != null) {
            builder.startArray("exclude");
            for (String value : this.excludes) {
                builder.value(value);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }
}

