/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util.ecs;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.ecs.ElasticCommonSchema;
import org.elasticsearch.hadoop.util.ecs.HostData;

public class MessageTemplate {
    private ElasticCommonSchema schema;
    private Map<String, String> labels;
    private Set<String> tags;
    private HostData host;
    private String eventCategory;
    private String eventType;

    public MessageTemplate(ElasticCommonSchema schema, Map<String, String> labels, Set<String> tags, HostData host, String eventCategory, String eventType) {
        Assert.hasText(eventCategory, "Missing category value for ECS template.");
        Assert.hasText(eventType, "Missing type value for ECS template.");
        this.schema = schema;
        this.labels = labels;
        this.tags = tags;
        this.host = host;
        this.eventCategory = eventCategory;
        this.eventType = eventType;
    }

    public BytesArray generateMessage(String ts, String message, String exceptionType, String exceptionMessage, String rawEvent) {
        Assert.hasText(ts, "Missing @timestamp value for ECS template.");
        Assert.hasText(message, "Missing message value for ECS template.");
        Assert.hasText(exceptionType, "Missing code value for ECS template.");
        Assert.hasText(exceptionMessage, "Missing message value for ECS template.");
        Assert.hasText(rawEvent, "Missing raw value for ECS template.");
        FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();
        JacksonJsonGenerator generator = new JacksonJsonGenerator(outputStream);
        generator.usePrettyPrint();
        generator.writeBeginObject();
        generator.writeFieldName("@timestamp").writeString(ts);
        if (this.tags != null && !this.tags.isEmpty()) {
            generator.writeFieldName("tags").writeBeginArray();
            for (String string : this.tags) {
                generator.writeString(string);
            }
            generator.writeEndArray();
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            generator.writeFieldName("labels").writeBeginObject();
            for (Map.Entry entry : this.labels.entrySet()) {
                generator.writeFieldName((String)entry.getKey()).writeString((String)entry.getValue());
            }
            generator.writeEndObject();
        }
        generator.writeFieldName("message").writeString(message);
        if (this.host != null && this.host.hasData()) {
            generator.writeFieldName("host").writeBeginObject();
            this.writeNullable(generator, "name", this.host.getName());
            this.writeNullable(generator, "ip", this.host.getIp());
            this.writeNullable(generator, "architecture", this.host.getArchitecture());
            if (this.host.getOsName() != null || this.host.getOsVersion() != null) {
                generator.writeFieldName("os").writeBeginObject();
                this.writeNullable(generator, "name", this.host.getOsName());
                this.writeNullable(generator, "version", this.host.getOsVersion());
                generator.writeEndObject();
            }
            if (this.host.getTimezoneOffsetSec() != null) {
                generator.writeFieldName("timezone").writeBeginObject();
                generator.writeFieldName("offset").writeBeginObject();
                generator.writeFieldName("sec").writeNumber(this.host.getTimezoneOffsetSec());
                generator.writeEndObject();
                generator.writeEndObject();
            }
            generator.writeEndObject();
        }
        generator.writeFieldName("error").writeBeginObject();
        generator.writeFieldName("code").writeString(exceptionType);
        generator.writeFieldName("message").writeString(exceptionMessage);
        generator.writeEndObject();
        generator.writeFieldName("event").writeBeginObject();
        generator.writeFieldName("category").writeString(this.eventCategory);
        generator.writeFieldName("type").writeString(this.eventType);
        generator.writeFieldName("raw").writeString(rawEvent);
        generator.writeFieldName("version").writeString(this.schema.getVersion());
        generator.writeEndObject();
        generator.writeEndObject();
        generator.close();
        return outputStream.bytes();
    }

    private void writeNullable(Generator generator, String key, String value) {
        if (value != null) {
            generator.writeFieldName(key).writeString(value);
        }
    }
}

