### Setting up the Amazon S3 connector

See the [Developer guide](../../docs/DEVELOPING.md) for setting up connectors.

### Overview

Advanced Sync Rules help manage data in Amazon S3 buckets. They take the following parameters:

1. `bucket`: This is the Amazon S3 bucket the rule applies to.
2. `extension` (optional): Lists which file types to sync. Defaults to syncing all types.
3. `prefix` (optional): String of prefix characters. The connector will index files and folder data that matches the string. Defaults to `""` (i.e. sync all bucket objects).

### Advanced sync rules examples

### Indexing files and folders recursively by prefix

#### Example 
Fetch files/folders in `folder1/docs`.

```json
[
  {
    "bucket": "bucket1",
    "prefix": "folder1/docs"
  }

]

```

#### Example

Fetch files/folder starting with `folder1`.

```json
[
  {
    "bucket": "bucket2",
    "prefix": "folder1"
  }
]

```

### Indexing files and folders by specifying extensions

#### Example

Fetch all objects which start with `abc` and then filter using file extensions.

```json
[
  {
    "bucket": "bucket2",
    "prefix": "abc",
    "extension": [".txt", ".png"]
  }
]

```
