/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoRowsResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealInsertVTIResultSetStatistics
extends RealNoRowsResultSetStatistics {
    public int rowCount;
    public boolean deferred;

    public RealInsertVTIResultSetStatistics(int rowCount, boolean deferred, long executeTime, ResultSetStatistics sourceResultSetStatistics) {
        super(executeTime, sourceResultSetStatistics);
        this.rowCount = rowCount;
        this.deferred = deferred;
        this.sourceResultSetStatistics = sourceResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        if (this.sourceResultSetStatistics == null) {
            return "";
        }
        return this.indent + MessageService.getTextMessage((String)"43Y46.U", (Object[])new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage((String)"43X16.U", (Object[])new Object[0]) + ": " + this.deferred + "\n" + this.indent + MessageService.getTextMessage((String)"43X68.U", (Object[])new Object[0]) + " = " + this.rowCount + "\n" + this.dumpTimeStats(this.indent) + (this.sourceResultSetStatistics == null ? "" : this.sourceResultSetStatistics.getStatementExecutionPlanText(1));
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        return this.sourceResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage((String)"43Y49.U", (Object[])new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.sourceResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.sourceResultSetStatistics != null) {
            this.sourceResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "INSERT";
    }

    @Override
    public String getRSXplainDetails() {
        return "VTI";
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), null, null, null, null, (UUID)parentID, null, null, this.rowCount, XPLAINUtil.getYesNoCharFromBoolean(this.deferred), null, null, null, null, null, null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }
}

