/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.wrapper;

import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.wrapper.WrapperKeyDeserializerConfig;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class WrapperKeyDeserializer<T>
implements Deserializer<T> {
    private Deserializer<T> inner;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new WrapperKeyDeserializerConfig(configs), isKey);
    }

    protected void configure(WrapperKeyDeserializerConfig config, boolean isKey) {
        if (!isKey) {
            throw new IllegalArgumentException("WrapperKeyDeserializer is only for keys");
        }
        this.inner = (Deserializer)config.getConfiguredInstance("wrapped.key.deserializer", Deserializer.class);
        this.inner.configure(config.originals(), isKey);
    }

    public T deserialize(String topic, byte[] bytes) {
        return this.deserialize(topic, null, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T deserialize(String topic, Headers headers, byte[] bytes) {
        try {
            Object object = this.inner.deserialize(topic, headers, bytes);
            return (T)object;
        }
        finally {
            AbstractKafkaSchemaSerDe.setKey(bytes);
        }
    }

    public void close() {
        this.inner.close();
    }
}

