/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;

public class DynamicQueryContext {
    private Item contextItem;
    private GlobalParameterSet parameters = new GlobalParameterSet();
    private Configuration config;
    private URIResolver uriResolver;
    private ErrorListener errorListener;
    private TraceListener traceListener;
    private UnparsedTextURIResolver unparsedTextURIResolver;
    private DateTimeValue currentDateTime;
    private Logger traceFunctionDestination;
    private int validationMode = 0;
    private boolean applyConversionRules = true;

    public DynamicQueryContext(Configuration config) {
        this.config = config;
        this.uriResolver = config.getURIResolver();
        this.errorListener = config.getErrorListener();
        try {
            this.traceListener = config.makeTraceListener();
        }
        catch (XPathException err) {
            throw new IllegalStateException(err.getMessage());
        }
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        this.traceFunctionDestination = config.getLogger();
    }

    public int getSchemaValidationMode() {
        return this.validationMode;
    }

    public void setSchemaValidationMode(int validationMode) {
        this.validationMode = validationMode;
    }

    public void setApplyFunctionConversionRulesToExternalVariables(boolean convert) {
        this.applyConversionRules = convert;
    }

    public boolean isApplyFunctionConversionRulesToExternalVariables() {
        return this.applyConversionRules;
    }

    public void setContextItem(Item item) {
        if (item == null) {
            throw new NullPointerException("Context item cannot be null");
        }
        if (item instanceof NodeInfo && !((NodeInfo)item).getConfiguration().isCompatible(this.config)) {
            throw new IllegalArgumentException("Supplied node must be built using the same or a compatible Configuration");
        }
        this.contextItem = item;
        this.parameters.put(StandardNames.SAXON_CONTEXT_ITEM, item);
    }

    public Item getContextItem() {
        return this.contextItem;
    }

    public void setParameter(StructuredQName expandedName, Sequence value) {
        if (this.parameters == null) {
            this.parameters = new GlobalParameterSet();
        }
        this.parameters.put(expandedName, value);
    }

    public void clearParameters() {
        this.parameters = new GlobalParameterSet();
    }

    public Sequence getParameter(StructuredQName expandedName) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(expandedName);
    }

    public GlobalParameterSet getParameters() {
        if (this.parameters == null) {
            return new GlobalParameterSet();
        }
        return this.parameters;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver resolver) {
        this.unparsedTextURIResolver = resolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextURIResolver;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setTraceListener(TraceListener listener) {
        this.traceListener = listener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceFunctionDestination(Logger stream) {
        this.traceFunctionDestination = stream;
    }

    public Logger getTraceFunctionDestination() {
        return this.traceFunctionDestination;
    }

    public DateTimeValue getCurrentDateTime() {
        return this.currentDateTime;
    }

    public void setCurrentDateTime(DateTimeValue dateTime) throws XPathException {
        this.currentDateTime = dateTime;
        if (dateTime.getComponent(7) == null) {
            throw new XPathException("Supplied date/time must include a timezone");
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void initializeController(Controller controller) throws XPathException {
        controller.setURIResolver(this.getURIResolver());
        controller.setErrorListener(this.getErrorListener());
        controller.addTraceListener(this.getTraceListener());
        if (this.unparsedTextURIResolver != null) {
            controller.setUnparsedTextURIResolver(this.unparsedTextURIResolver);
        }
        controller.setTraceFunctionDestination(this.getTraceFunctionDestination());
        controller.setSchemaValidationMode(this.getSchemaValidationMode());
        DateTimeValue currentDateTime = this.getCurrentDateTime();
        if (currentDateTime != null) {
            try {
                controller.setCurrentDateTime(currentDateTime);
            }
            catch (XPathException e) {
                throw new AssertionError((Object)e);
            }
        }
        controller.getBindery().setApplyFunctionConversionRulesToExternalVariables(this.applyConversionRules);
        controller.getExecutable().checkAllRequiredParamsArePresent(this.parameters);
        controller.getBindery().defineGlobalParameters(this.parameters);
    }
}

