/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Config update request")
public class ConfigUpdateRequest {
    private Optional<String> alias;
    private Optional<Boolean> normalize;
    private Optional<Boolean> validateFields;
    private Optional<Boolean> validateRules;
    private Optional<String> compatibilityLevel;
    private Optional<String> compatibilityGroup;
    private Optional<Metadata> defaultMetadata;
    private Optional<Metadata> overrideMetadata;
    private Optional<RuleSet> defaultRuleSet;
    private Optional<RuleSet> overrideRuleSet;

    public ConfigUpdateRequest() {
    }

    public ConfigUpdateRequest(Config config) {
        this.setAlias(config.getAlias());
        this.setNormalize(config.isNormalize());
        this.setValidateFields(config.isValidateFields());
        this.setValidateRules(config.isValidateRules());
        this.setCompatibilityLevel(config.getCompatibilityLevel());
        this.setCompatibilityGroup(config.getCompatibilityGroup());
        this.setDefaultMetadata(config.getDefaultMetadata());
        this.setOverrideMetadata(config.getOverrideMetadata());
        this.setDefaultRuleSet(config.getDefaultRuleSet());
        this.setOverrideRuleSet(config.getOverrideRuleSet());
    }

    public static ConfigUpdateRequest fromJson(String json) throws IOException {
        return (ConfigUpdateRequest)JacksonMapper.INSTANCE.readValue(json, ConfigUpdateRequest.class);
    }

    @JsonProperty(value="alias")
    public Optional<String> getOptionalAlias() {
        return this.alias;
    }

    @JsonIgnore
    public String getAlias() {
        return this.alias != null ? (String)this.alias.orElse(null) : null;
    }

    @JsonProperty(value="alias")
    public void setAlias(Optional<String> alias) {
        this.alias = alias;
    }

    @JsonIgnore
    public void setAlias(String alias) {
        this.alias = alias != null ? Optional.of(alias) : null;
    }

    @JsonProperty(value="normalize")
    public Optional<Boolean> isOptionalNormalize() {
        return this.normalize;
    }

    @JsonIgnore
    public Boolean isNormalize() {
        return this.normalize != null ? (Boolean)this.normalize.orElse(null) : null;
    }

    @JsonProperty(value="normalize")
    public void setNormalize(Optional<Boolean> normalize) {
        this.normalize = normalize;
    }

    @JsonIgnore
    public void setNormalize(Boolean normalize) {
        this.normalize = normalize != null ? Optional.of(normalize) : null;
    }

    @JsonProperty(value="validateFields")
    public Optional<Boolean> isOptionalValidateFields() {
        return this.validateFields;
    }

    @JsonIgnore
    public Boolean isValidateFields() {
        return this.validateFields != null ? (Boolean)this.validateFields.orElse(null) : null;
    }

    @JsonProperty(value="validateFields")
    public void setValidateFields(Optional<Boolean> validateFields) {
        this.validateFields = validateFields;
    }

    @JsonIgnore
    public void setValidateFields(Boolean validateFields) {
        this.validateFields = validateFields != null ? Optional.of(validateFields) : null;
    }

    @JsonProperty(value="validateRules")
    public Optional<Boolean> isOptionalValidateRules() {
        return this.validateRules;
    }

    @JsonIgnore
    public Boolean isValidateRules() {
        return this.validateRules != null ? (Boolean)this.validateRules.orElse(null) : null;
    }

    @JsonProperty(value="validateRules")
    public void setValidateRules(Optional<Boolean> validateRules) {
        this.validateRules = validateRules;
    }

    @JsonIgnore
    public void setValidateRules(Boolean validateRules) {
        this.validateRules = validateRules != null ? Optional.of(validateRules) : null;
    }

    @Schema(description="Compatibility Level", allowableValues={"BACKWARD", "BACKWARD_TRANSITIVE", "FORWARD", "FORWARD_TRANSITIVE", "FULL", "FULL_TRANSITIVE", "NONE"}, example="FULL_TRANSITIVE")
    @JsonProperty(value="compatibility")
    public Optional<String> getOptionalCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    @JsonIgnore
    public String getCompatibilityLevel() {
        return this.compatibilityLevel != null ? (String)this.compatibilityLevel.orElse(null) : null;
    }

    @JsonProperty(value="compatibility")
    public void setCompatibilityLevel(Optional<String> compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    @JsonIgnore
    public void setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel != null ? Optional.of(compatibilityLevel) : null;
    }

    @JsonProperty(value="compatibilityGroup")
    public Optional<String> getOptionalCompatibilityGroup() {
        return this.compatibilityGroup;
    }

    @JsonIgnore
    public String getCompatibilityGroup() {
        return this.compatibilityGroup != null ? (String)this.compatibilityGroup.orElse(null) : null;
    }

    @JsonProperty(value="compatibilityGroup")
    public void setCompatibilityGroup(Optional<String> compatibilityGroup) {
        this.compatibilityGroup = compatibilityGroup;
    }

    @JsonIgnore
    public void setCompatibilityGroup(String compatibilityGroup) {
        this.compatibilityGroup = compatibilityGroup != null ? Optional.of(compatibilityGroup) : null;
    }

    @JsonProperty(value="defaultMetadata")
    public Optional<Metadata> getOptionalDefaultMetadata() {
        return this.defaultMetadata;
    }

    @JsonIgnore
    public Metadata getDefaultMetadata() {
        return this.defaultMetadata != null ? (Metadata)this.defaultMetadata.orElse(null) : null;
    }

    @JsonProperty(value="defaultMetadata")
    public void setDefaultMetadata(Optional<Metadata> defaultMetadata) {
        this.defaultMetadata = defaultMetadata;
    }

    @JsonIgnore
    public void setDefaultMetadata(Metadata defaultMetadata) {
        this.defaultMetadata = defaultMetadata != null ? Optional.of(defaultMetadata) : null;
    }

    @JsonProperty(value="overrideMetadata")
    public Optional<Metadata> getOptionalOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonIgnore
    public Metadata getOverrideMetadata() {
        return this.overrideMetadata != null ? (Metadata)this.overrideMetadata.orElse(null) : null;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Optional<Metadata> overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    @JsonIgnore
    public void setOverrideMetadata(Metadata overrideMetadata) {
        this.overrideMetadata = overrideMetadata != null ? Optional.of(overrideMetadata) : null;
    }

    @JsonProperty(value="defaultRuleSet")
    public Optional<RuleSet> getOptionalDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    @JsonIgnore
    public RuleSet getDefaultRuleSet() {
        return this.defaultRuleSet != null ? (RuleSet)this.defaultRuleSet.orElse(null) : null;
    }

    @JsonProperty(value="defaultRuleSet")
    public void setDefaultRuleSet(Optional<RuleSet> defaultRuleSet) {
        this.defaultRuleSet = defaultRuleSet;
    }

    @JsonIgnore
    public void setDefaultRuleSet(RuleSet defaultRuleSet) {
        this.defaultRuleSet = defaultRuleSet != null ? Optional.of(defaultRuleSet) : null;
    }

    @JsonProperty(value="overrideRuleSet")
    public Optional<RuleSet> getOptionalOverrideRuleSet() {
        return this.overrideRuleSet;
    }

    @JsonIgnore
    public RuleSet getOverrideRuleSet() {
        return this.overrideRuleSet != null ? (RuleSet)this.overrideRuleSet.orElse(null) : null;
    }

    @JsonProperty(value="overrideRuleSet")
    public void setOverrideRuleSet(Optional<RuleSet> overrideRuleSet) {
        this.overrideRuleSet = overrideRuleSet;
    }

    @JsonIgnore
    public void setOverrideRuleSet(RuleSet overrideRuleSet) {
        this.overrideRuleSet = overrideRuleSet != null ? Optional.of(overrideRuleSet) : null;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigUpdateRequest that = (ConfigUpdateRequest)o;
        return Objects.equals(this.alias, that.alias) && Objects.equals(this.normalize, that.normalize) && Objects.equals(this.validateFields, that.validateFields) && Objects.equals(this.validateRules, that.validateRules) && Objects.equals(this.compatibilityLevel, that.compatibilityLevel) && Objects.equals(this.compatibilityGroup, that.compatibilityGroup) && Objects.equals(this.defaultMetadata, that.defaultMetadata) && Objects.equals(this.overrideMetadata, that.overrideMetadata) && Objects.equals(this.defaultRuleSet, that.defaultRuleSet) && Objects.equals(this.overrideRuleSet, that.overrideRuleSet);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.normalize, this.validateFields, this.validateRules, this.compatibilityLevel, this.compatibilityGroup, this.defaultMetadata, this.overrideMetadata, this.defaultRuleSet, this.overrideRuleSet);
    }
}

