/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.support;

import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xpack.spatial.index.fielddata.CartesianShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafShapeFieldData;
import org.elasticsearch.xpack.spatial.search.aggregations.support.ShapeValuesSource;

public abstract class CartesianShapeValuesSource
extends ShapeValuesSource<CartesianShapeValues> {
    public static final CartesianShapeValuesSource EMPTY = new CartesianShapeValuesSource(){

        @Override
        public CartesianShapeValues shapeValues(LeafReaderContext context) {
            return CartesianShapeValues.EMPTY;
        }
    };

    @Override
    protected Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) {
        throw AggregationErrors.unsupportedRounding("shape");
    }

    public static class Fielddata
    extends CartesianShapeValuesSource {
        protected final IndexShapeFieldData<CartesianShapeValues> indexFieldData;

        public Fielddata(IndexShapeFieldData<CartesianShapeValues> indexFieldData) {
            this.indexFieldData = indexFieldData;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return ((LeafShapeFieldData)this.indexFieldData.load(context)).getBytesValues();
        }

        @Override
        public CartesianShapeValues shapeValues(LeafReaderContext context) {
            return (CartesianShapeValues)((LeafShapeFieldData)this.indexFieldData.load(context)).getShapeValues();
        }
    }
}

