/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.geometry.simplify.SimplificationErrorCalculator;
import org.elasticsearch.geometry.simplify.StreamingGeometrySimplifier;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.spatial.search.aggregations.GeoLineAggregationBuilder;
import org.elasticsearch.xpack.spatial.search.aggregations.InternalGeoLine;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoLineMultiValuesSource;

class TimeSeriesGeoLineBuckets
implements Releasable {
    private static final long NO_BUCKET = -1L;
    private final GeoLineMultiValuesSource valuesSources;
    private final int bucketSize;
    private final Supplier<InternalGeoLine> geoLineBuilder;
    private long currentBucket;
    private final Simplifier simplifier;
    private final HashMap<Long, InternalAggregation> geoLines = new HashMap();

    TimeSeriesGeoLineBuckets(int bucketSize, GeoLineMultiValuesSource valuesSources, Supplier<InternalGeoLine> geoLineBuilder, Function<Long, Long> circuitBreaker) {
        this.valuesSources = valuesSources;
        this.bucketSize = bucketSize;
        this.geoLineBuilder = geoLineBuilder;
        this.currentBucket = -1L;
        this.simplifier = new Simplifier(bucketSize, circuitBreaker);
    }

    Leaf forLeaf(AggregationExecutionContext aggCtx) throws IOException {
        return new Leaf(aggCtx.getLeafReaderContext());
    }

    void doPostCollection() {
        this.flushBucket(-1L);
    }

    @Override
    public void close() {
        this.simplifier.reset();
    }

    private void flushBucket(long bucket) {
        if (bucket != this.currentBucket) {
            if (this.currentBucket != -1L) {
                if (this.geoLines.containsKey(this.currentBucket)) {
                    throw new IllegalStateException("Geoline already exists for bucket " + this.currentBucket);
                }
                this.geoLines.put(this.currentBucket, this.geoLineBuilder.get());
                this.simplifier.reset();
            }
            this.currentBucket = bucket;
        }
    }

    InternalGeoLine buildInternalGeoLine(String name, Map<String, Object> metadata, boolean includeSorts, SortOrder sortOrder) {
        LineStream line = this.simplifier.produce();
        boolean complete = this.simplifier.length() < this.bucketSize;
        double[] sortVals = line.sortValues;
        long[] bucketLine = line.encodedPoints;
        if (sortOrder == SortOrder.ASC) {
            ArrayUtils.reverseSubArray(sortVals, 0, sortVals.length);
            ArrayUtils.reverseSubArray(bucketLine, 0, bucketLine.length);
        }
        return new InternalGeoLine(name, bucketLine, sortVals, metadata, complete, includeSorts, sortOrder, this.bucketSize, true, true);
    }

    public InternalAggregation getGeolineForBucket(long bucket) {
        return this.geoLines.get(bucket);
    }

    static class Simplifier
    extends StreamingGeometrySimplifier<LineStream>
    implements StreamingGeometrySimplifier.PointConstructor,
    StreamingGeometrySimplifier.PointResetter {
        double currentSortValue;
        private final Function<Long, Long> circuitBreaker;

        Simplifier(int maxPoints, Function<Long, Long> circuitBreaker) {
            super("GeoLineTSDB", maxPoints, SimplificationErrorCalculator.TRIANGLE_AREA, null);
            this.pointConstructor = this;
            this.pointResetter = this;
            this.circuitBreaker = circuitBreaker;
        }

        @Override
        public StreamingGeometrySimplifier.PointError newPoint(int index, double x, double y) {
            return new SimplifiablePoint(index, x, y, this.currentSortValue);
        }

        @Override
        public StreamingGeometrySimplifier.PointError resetPoint(StreamingGeometrySimplifier.PointError point, int index, double x, double y) {
            return ((SimplifiablePoint)point).reset(index, x, y, this.currentSortValue);
        }

        @Override
        public LineStream produce() {
            this.circuitBreaker.apply(128L * (long)this.length());
            return new LineStream(this.length, this.points);
        }

        public int length() {
            return this.length;
        }
    }

    protected class Leaf {
        private final SortedNumericDoubleValues docSortValues;
        private final MultiGeoPointValues docGeoPointValues;

        protected Leaf(LeafReaderContext ctx) throws IOException {
            this.docSortValues = TimeSeriesGeoLineBuckets.this.valuesSources.getNumericField(GeoLineAggregationBuilder.SORT_FIELD.getPreferredName(), ctx);
            this.docGeoPointValues = TimeSeriesGeoLineBuckets.this.valuesSources.getGeoPointField(GeoLineAggregationBuilder.POINT_FIELD.getPreferredName(), ctx);
        }

        private boolean loadSortField(int doc) throws IOException {
            TimeSeriesGeoLineBuckets.this.simplifier.currentSortValue = -9.223372036854776E18;
            if (this.docSortValues.advanceExact(doc)) {
                if (this.docSortValues.docValueCount() > 1) {
                    throw AggregationErrors.unsupportedMultivalue();
                }
                assert (this.docSortValues.docValueCount() == 1);
                TimeSeriesGeoLineBuckets.this.simplifier.currentSortValue = this.docSortValues.nextValue();
                return true;
            }
            return false;
        }

        private void loadPointField(int doc) throws IOException {
            if (!this.docGeoPointValues.advanceExact(doc)) {
                return;
            }
            if (this.docGeoPointValues.docValueCount() > 1) {
                throw AggregationErrors.unsupportedMultivalue();
            }
            GeoPoint point = this.docGeoPointValues.nextValue();
            TimeSeriesGeoLineBuckets.this.simplifier.consume(point.getX(), point.getY());
        }

        public void collect(int doc, long bucket) throws IOException {
            TimeSeriesGeoLineBuckets.this.flushBucket(bucket);
            if (this.loadSortField(doc)) {
                this.loadPointField(doc);
            }
        }
    }

    static class LineStream
    implements Geometry {
        final long[] encodedPoints;
        final double[] sortValues;

        private LineStream(int length, StreamingGeometrySimplifier.PointError[] points) {
            this.encodedPoints = new long[length];
            this.sortValues = new double[length];
            for (int i = 0; i < length; ++i) {
                SimplifiablePoint p = (SimplifiablePoint)points[i];
                this.encodedPoints[i] = p.encoded;
                this.sortValues[i] = p.sortValue;
            }
        }

        @Override
        public ShapeType type() {
            return ShapeType.LINESTRING;
        }

        @Override
        public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
            double[] x = new double[this.encodedPoints.length];
            double[] y = new double[this.encodedPoints.length];
            for (int i = 0; i < this.encodedPoints.length; ++i) {
                x[i] = LineStream.decodeLongitude(this.encodedPoints[i]);
                y[i] = LineStream.decodeLatitude(this.encodedPoints[i]);
            }
            Line line = new Line(x, y);
            return visitor.visit(line);
        }

        private static double decodeLongitude(long encoded) {
            return GeoEncodingUtils.decodeLongitude((int)(encoded >>> 32));
        }

        private static double decodeLatitude(long encoded) {
            return GeoEncodingUtils.decodeLatitude((int)(encoded & 0xFFFFFFFFL));
        }

        @Override
        public boolean isEmpty() {
            return this.encodedPoints.length == 0;
        }

        public String toString() {
            return WellKnownText.toWKT(this);
        }
    }

    static class SimplifiablePoint
    extends StreamingGeometrySimplifier.PointError {
        private double sortValue;
        private long encoded;

        SimplifiablePoint(int index, double x, double y, double sortValue) {
            super(index, x, y);
            this.sortValue = sortValue;
            this.setEncoded(x, y);
        }

        private StreamingGeometrySimplifier.PointError reset(int index, double x, double y, double sortValue) {
            super.reset(index, x, y);
            this.sortValue = sortValue;
            this.setEncoded(x, y);
            return this;
        }

        private void setEncoded(double x, double y) {
            this.encoded = (long)GeoEncodingUtils.encodeLongitude(x) << 32 | (long)GeoEncodingUtils.encodeLatitude(y) & 0xFFFFFFFFL;
        }
    }
}

