/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import org.apache.lucene.geo.Component2D;
import org.apache.lucene.index.PointValues;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;

class Component2DRelationVisitor
extends TriangleTreeVisitor.TriangleTreeDecodedVisitor {
    private GeoRelation relation;
    private Component2D component2D;

    Component2DRelationVisitor(CoordinateEncoder encoder) {
        super(encoder);
    }

    public void reset(Component2D component2D) {
        this.component2D = component2D;
        this.relation = null;
    }

    public GeoRelation relation() {
        return this.relation == null ? GeoRelation.QUERY_DISJOINT : this.relation;
    }

    @Override
    protected void visitDecodedPoint(double x, double y) {
        if (this.component2D.contains(x, y)) {
            this.relation = this.canBeInside() && this.component2D.withinPoint(x, y) == Component2D.WithinRelation.CANDIDATE ? GeoRelation.QUERY_INSIDE : (this.canBeContained() ? GeoRelation.QUERY_CONTAINS : GeoRelation.QUERY_CROSSES);
        } else {
            this.adjustRelationForNotIntersectingComponent();
        }
    }

    @Override
    protected void visitDecodedLine(double aX, double aY, double bX, double bY, byte metadata) {
        if (this.component2D.intersectsLine(aX, aY, bX, bY)) {
            boolean ab = TriangleTreeVisitor.abFromTriangle(metadata);
            this.relation = this.canBeInside() && this.component2D.withinLine(aX, aY, ab, bX, bY) == Component2D.WithinRelation.CANDIDATE ? GeoRelation.QUERY_INSIDE : (this.canBeContained() && this.component2D.containsLine(aX, aY, bX, bY) ? GeoRelation.QUERY_CONTAINS : GeoRelation.QUERY_CROSSES);
        } else {
            this.adjustRelationForNotIntersectingComponent();
        }
    }

    @Override
    protected void visitDecodedTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
        if (this.component2D.intersectsTriangle(aX, aY, bX, bY, cX, cY)) {
            boolean ab = TriangleTreeVisitor.abFromTriangle(metadata);
            boolean bc = TriangleTreeVisitor.bcFromTriangle(metadata);
            boolean ca = TriangleTreeVisitor.caFromTriangle(metadata);
            this.relation = this.canBeInside() && this.component2D.withinTriangle(aX, aY, ab, bX, bY, bc, cX, cY, ca) == Component2D.WithinRelation.CANDIDATE ? GeoRelation.QUERY_INSIDE : (this.canBeContained() && this.component2D.containsTriangle(aX, aY, bX, bY, cX, cY) ? GeoRelation.QUERY_CONTAINS : GeoRelation.QUERY_CROSSES);
        } else {
            this.adjustRelationForNotIntersectingComponent();
        }
    }

    @Override
    public boolean push() {
        return this.relation != GeoRelation.QUERY_CROSSES;
    }

    @Override
    public boolean pushDecodedX(double minX) {
        if (this.component2D.getMaxX() >= minX) {
            return true;
        }
        this.adjustRelationForNotIntersectingComponent();
        return false;
    }

    @Override
    public boolean pushDecodedY(double minY) {
        if (this.component2D.getMaxY() >= minY) {
            return true;
        }
        this.adjustRelationForNotIntersectingComponent();
        return false;
    }

    @Override
    public boolean pushDecoded(double maxX, double maxY) {
        if (this.component2D.getMinY() <= maxY && this.component2D.getMinX() <= maxX) {
            return true;
        }
        this.adjustRelationForNotIntersectingComponent();
        return false;
    }

    @Override
    public boolean pushDecoded(double minX, double minY, double maxX, double maxY) {
        PointValues.Relation rel = this.component2D.relate(minX, maxX, minY, maxY);
        if (rel == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            this.relation = GeoRelation.QUERY_DISJOINT;
            return false;
        }
        return true;
    }

    private void adjustRelationForNotIntersectingComponent() {
        if (this.relation == null) {
            this.relation = GeoRelation.QUERY_DISJOINT;
        } else if (this.relation == GeoRelation.QUERY_CONTAINS) {
            this.relation = GeoRelation.QUERY_CROSSES;
        }
    }

    private boolean canBeContained() {
        return this.relation == null || this.relation == GeoRelation.QUERY_CONTAINS;
    }

    private boolean canBeInside() {
        return this.relation != GeoRelation.QUERY_CONTAINS;
    }
}

