/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.RetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class TimeRetentionPolicyConfig
implements RetentionPolicyConfig {
    private static final String NAME = "transform_retention_policy_time";
    private static long MIN_AGE_SECONDS = 60L;
    private final String field;
    private final TimeValue maxAge;
    private static final ConstructingObjectParser<TimeRetentionPolicyConfig, Void> STRICT_PARSER = TimeRetentionPolicyConfig.createParser(false);
    private static final ConstructingObjectParser<TimeRetentionPolicyConfig, Void> LENIENT_PARSER = TimeRetentionPolicyConfig.createParser(true);

    private static ConstructingObjectParser<TimeRetentionPolicyConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser<TimeRetentionPolicyConfig, Void> parser = new ConstructingObjectParser<TimeRetentionPolicyConfig, Void>(NAME, lenient, args -> {
            String field = (String)args[0];
            TimeValue maxAge = (TimeValue)args[1];
            return new TimeRetentionPolicyConfig(field, maxAge);
        });
        parser.declareString(ConstructingObjectParser.constructorArg(), TransformField.FIELD);
        parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> TimeValue.parseTimeValue(p.text(), TransformField.MAX_AGE.getPreferredName()), TransformField.MAX_AGE, ObjectParser.ValueType.STRING);
        return parser;
    }

    public TimeRetentionPolicyConfig(String field, TimeValue maxAge) {
        this.field = ExceptionsHelper.requireNonNull(field, TransformField.FIELD.getPreferredName());
        this.maxAge = ExceptionsHelper.requireNonNull(maxAge, TransformField.MAX_AGE.getPreferredName());
    }

    public TimeRetentionPolicyConfig(StreamInput in) throws IOException {
        this.field = in.readString();
        this.maxAge = in.readTimeValue();
    }

    public String getField() {
        return this.field;
    }

    public TimeValue getMaxAge() {
        return this.maxAge;
    }

    @Override
    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.maxAge.getSeconds() < MIN_AGE_SECONDS) {
            validationException = ValidateActions.addValidationError("retention_policy.time.max_age must be greater than " + MIN_AGE_SECONDS + "s, found [" + String.valueOf(this.maxAge) + "]", validationException);
        }
        if (this.maxAge.compareTo(TimeValue.MAX_VALUE) > 0) {
            validationException = ValidateActions.addValidationError("retention_policy.time.max_age must not be greater than [" + String.valueOf(TimeValue.MAX_VALUE) + "]", validationException);
        }
        return validationException;
    }

    @Override
    public void checkForDeprecations(String id, NamedXContentRegistry namedXContentRegistry, Consumer<DeprecationIssue> onDeprecation) {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeTimeValue(this.maxAge);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.FIELD.getPreferredName(), this.field);
        builder.field(TransformField.MAX_AGE.getPreferredName(), this.maxAge.getStringRep());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimeRetentionPolicyConfig that = (TimeRetentionPolicyConfig)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.maxAge, that.maxAge);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.maxAge);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static TimeRetentionPolicyConfig parse(XContentParser parser) {
        return LENIENT_PARSER.apply(parser, null);
    }

    public static TimeRetentionPolicyConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? LENIENT_PARSER.apply(parser, null) : STRICT_PARSER.apply(parser, null);
    }

    @Override
    public String getWriteableName() {
        return TransformField.TIME.getPreferredName();
    }
}

