/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.textstructure.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.textstructure.action.AbstractFindStructureRequest;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureResponse;

public class FindStructureAction
extends ActionType<FindStructureResponse> {
    public static final FindStructureAction INSTANCE = new FindStructureAction();
    public static final String NAME = "cluster:monitor/text_structure/findstructure";

    private FindStructureAction() {
        super(NAME);
    }

    public static class Request
    extends AbstractFindStructureRequest {
        private BytesReference sample;

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.sample = in.readBytesReference();
        }

        public BytesReference getSample() {
            return this.sample;
        }

        public void setSample(BytesReference sample) {
            this.sample = sample;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = super.validate();
            if (this.sample == null || this.sample.length() == 0) {
                validationException = ValidateActions.addValidationError("sample must be specified", validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBytesReference(this.sample);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.sample);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Request that = (Request)other;
            return super.equals(other) && Objects.equals(this.sample, that.sample);
        }
    }
}

