/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.textstructure.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.textstructure.structurefinder.TextStructure;

public abstract class AbstractFindStructureRequest
extends LegacyActionRequest {
    public static final int MIN_SAMPLE_LINE_COUNT = 2;
    public static final ParseField LINES_TO_SAMPLE = new ParseField("lines_to_sample", new String[0]);
    public static final ParseField DOCUMENTS_TO_SAMPLE = new ParseField("documents_to_sample", new String[0]);
    public static final ParseField LINE_MERGE_SIZE_LIMIT = new ParseField("line_merge_size_limit", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final ParseField CHARSET = TextStructure.CHARSET;
    public static final ParseField FORMAT = TextStructure.FORMAT;
    public static final ParseField COLUMN_NAMES = TextStructure.COLUMN_NAMES;
    public static final ParseField HAS_HEADER_ROW = TextStructure.HAS_HEADER_ROW;
    public static final ParseField DELIMITER = TextStructure.DELIMITER;
    public static final ParseField QUOTE = TextStructure.QUOTE;
    public static final ParseField SHOULD_TRIM_FIELDS = TextStructure.SHOULD_TRIM_FIELDS;
    public static final ParseField GROK_PATTERN = TextStructure.GROK_PATTERN;
    public static final ParseField TIMESTAMP_FORMAT = new ParseField("timestamp_format", new String[0]);
    public static final ParseField TIMESTAMP_FIELD = TextStructure.TIMESTAMP_FIELD;
    public static final ParseField ECS_COMPATIBILITY = TextStructure.ECS_COMPATIBILITY;
    private static final String ARG_INCOMPATIBLE_WITH_FORMAT_TEMPLATE = "[%s] may only be specified if [" + FORMAT.getPreferredName() + "] is [%s]";
    private Integer linesToSample;
    private Integer lineMergeSizeLimit;
    private TimeValue timeout;
    private String charset;
    private TextStructure.Format format;
    private List<String> columnNames;
    private Boolean hasHeaderRow;
    private Character delimiter;
    private Character quote;
    private Boolean shouldTrimFields;
    private String grokPattern;
    private String ecsCompatibility;
    private String timestampFormat;
    private String timestampField;

    AbstractFindStructureRequest() {
    }

    AbstractFindStructureRequest(StreamInput in) throws IOException {
        super(in);
        this.linesToSample = in.readOptionalVInt();
        this.lineMergeSizeLimit = in.readOptionalVInt();
        this.timeout = in.readOptionalTimeValue();
        this.charset = in.readOptionalString();
        this.format = in.readBoolean() ? in.readEnum(TextStructure.Format.class) : null;
        this.columnNames = in.readBoolean() ? in.readStringCollectionAsList() : null;
        this.hasHeaderRow = in.readOptionalBoolean();
        this.delimiter = in.readBoolean() ? Character.valueOf((char)in.readVInt()) : null;
        this.quote = in.readBoolean() ? Character.valueOf((char)in.readVInt()) : null;
        this.shouldTrimFields = in.readOptionalBoolean();
        this.grokPattern = in.readOptionalString();
        this.ecsCompatibility = in.readOptionalString();
        this.timestampFormat = in.readOptionalString();
        this.timestampField = in.readOptionalString();
    }

    public Integer getLinesToSample() {
        return this.linesToSample;
    }

    public void setLinesToSample(Integer linesToSample) {
        this.linesToSample = linesToSample;
    }

    public Integer getLineMergeSizeLimit() {
        return this.lineMergeSizeLimit;
    }

    public void setLineMergeSizeLimit(Integer lineMergeSizeLimit) {
        this.lineMergeSizeLimit = lineMergeSizeLimit;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset == null || charset.isEmpty() ? null : charset;
    }

    public TextStructure.Format getFormat() {
        return this.format;
    }

    public void setFormat(TextStructure.Format format) {
        this.format = format;
    }

    public void setFormat(String format) {
        this.format = format == null || format.isEmpty() ? null : TextStructure.Format.fromString(format);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames == null || columnNames.isEmpty() ? null : columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames == null || columnNames.length == 0 ? null : Arrays.asList(columnNames);
    }

    public Boolean getHasHeaderRow() {
        return this.hasHeaderRow;
    }

    public void setHasHeaderRow(Boolean hasHeaderRow) {
        this.hasHeaderRow = hasHeaderRow;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (delimiter == null || delimiter.isEmpty()) {
            this.delimiter = null;
        } else if (delimiter.length() == 1) {
            this.delimiter = Character.valueOf(delimiter.charAt(0));
        } else {
            throw new IllegalArgumentException(DELIMITER.getPreferredName() + " must be a single character");
        }
    }

    public Character getQuote() {
        return this.quote;
    }

    public void setQuote(Character quote) {
        this.quote = quote;
    }

    public void setQuote(String quote) {
        if (quote == null || quote.isEmpty()) {
            this.quote = null;
        } else if (quote.length() == 1) {
            this.quote = Character.valueOf(quote.charAt(0));
        } else {
            throw new IllegalArgumentException(QUOTE.getPreferredName() + " must be a single character");
        }
    }

    public Boolean getShouldTrimFields() {
        return this.shouldTrimFields;
    }

    public void setShouldTrimFields(Boolean shouldTrimFields) {
        this.shouldTrimFields = shouldTrimFields;
    }

    public String getGrokPattern() {
        return this.grokPattern;
    }

    public void setGrokPattern(String grokPattern) {
        this.grokPattern = grokPattern == null || grokPattern.isEmpty() ? null : grokPattern;
    }

    public String getEcsCompatibility() {
        return this.ecsCompatibility;
    }

    public void setEcsCompatibility(String ecsCompatibility) {
        this.ecsCompatibility = ecsCompatibility == null || ecsCompatibility.isEmpty() ? null : ecsCompatibility;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat == null || timestampFormat.isEmpty() ? null : timestampFormat;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField == null || timestampField.isEmpty() ? null : timestampField;
    }

    private static ActionRequestValidationException addIncompatibleArgError(ParseField arg, TextStructure.Format format, ActionRequestValidationException validationException) {
        return ValidateActions.addValidationError(String.format(Locale.ROOT, ARG_INCOMPATIBLE_WITH_FORMAT_TEMPLATE, new Object[]{arg.getPreferredName(), format}), validationException);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.linesToSample != null && this.linesToSample < 2) {
            validationException = ValidateActions.addValidationError("[" + LINES_TO_SAMPLE.getPreferredName() + "] must be at least [2] if specified", validationException);
        }
        if (this.lineMergeSizeLimit != null && this.lineMergeSizeLimit <= 0) {
            validationException = ValidateActions.addValidationError("[" + LINE_MERGE_SIZE_LIMIT.getPreferredName() + "] must be positive if specified", validationException);
        }
        if (this.format != TextStructure.Format.DELIMITED) {
            if (this.columnNames != null) {
                validationException = AbstractFindStructureRequest.addIncompatibleArgError(COLUMN_NAMES, TextStructure.Format.DELIMITED, validationException);
            }
            if (this.hasHeaderRow != null) {
                validationException = AbstractFindStructureRequest.addIncompatibleArgError(HAS_HEADER_ROW, TextStructure.Format.DELIMITED, validationException);
            }
            if (this.delimiter != null) {
                validationException = AbstractFindStructureRequest.addIncompatibleArgError(DELIMITER, TextStructure.Format.DELIMITED, validationException);
            }
            if (this.quote != null) {
                validationException = AbstractFindStructureRequest.addIncompatibleArgError(QUOTE, TextStructure.Format.DELIMITED, validationException);
            }
            if (this.shouldTrimFields != null) {
                validationException = AbstractFindStructureRequest.addIncompatibleArgError(SHOULD_TRIM_FIELDS, TextStructure.Format.DELIMITED, validationException);
            }
        }
        if (this.format != TextStructure.Format.SEMI_STRUCTURED_TEXT && this.grokPattern != null) {
            validationException = AbstractFindStructureRequest.addIncompatibleArgError(GROK_PATTERN, TextStructure.Format.SEMI_STRUCTURED_TEXT, validationException);
        }
        if (this.ecsCompatibility != null && !GrokBuiltinPatterns.isValidEcsCompatibilityMode(this.ecsCompatibility)) {
            validationException = ValidateActions.addValidationError("[" + ECS_COMPATIBILITY.getPreferredName() + "] must be one of [" + String.join((CharSequence)", ", GrokBuiltinPatterns.ECS_COMPATIBILITY_MODES) + "] if specified", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalVInt(this.linesToSample);
        out.writeOptionalVInt(this.lineMergeSizeLimit);
        out.writeOptionalTimeValue(this.timeout);
        out.writeOptionalString(this.charset);
        if (this.format == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeEnum(this.format);
        }
        if (this.columnNames == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeStringCollection(this.columnNames);
        }
        out.writeOptionalBoolean(this.hasHeaderRow);
        if (this.delimiter == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.delimiter.charValue());
        }
        if (this.quote == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.quote.charValue());
        }
        out.writeOptionalBoolean(this.shouldTrimFields);
        out.writeOptionalString(this.grokPattern);
        out.writeOptionalString(this.ecsCompatibility);
        out.writeOptionalString(this.timestampFormat);
        out.writeOptionalString(this.timestampField);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linesToSample, this.lineMergeSizeLimit, this.timeout, this.charset, this.format, this.columnNames, this.hasHeaderRow, this.delimiter, this.grokPattern, this.ecsCompatibility, this.timestampFormat, this.timestampField});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractFindStructureRequest that = (AbstractFindStructureRequest)other;
        return Objects.equals(this.linesToSample, that.linesToSample) && Objects.equals(this.lineMergeSizeLimit, that.lineMergeSizeLimit) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.charset, that.charset) && Objects.equals((Object)this.format, (Object)that.format) && Objects.equals(this.columnNames, that.columnNames) && Objects.equals(this.hasHeaderRow, that.hasHeaderRow) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.grokPattern, that.grokPattern) && Objects.equals(this.ecsCompatibility, that.ecsCompatibility) && Objects.equals(this.timestampFormat, that.timestampFormat) && Objects.equals(this.timestampField, that.timestampField);
    }
}

