/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ApplicationPrivilegeDescriptor
implements ToXContentObject,
Writeable {
    public static final String DOC_TYPE_VALUE = "application-privilege";
    private static final ObjectParser<Builder, Boolean> PARSER = new ObjectParser("application-privilege", Builder::new);
    private String application;
    private String name;
    private Set<String> actions;
    private Map<String, Object> metadata;

    public ApplicationPrivilegeDescriptor(String application, String name, Set<String> actions, Map<String, Object> metadata) {
        this.application = Objects.requireNonNull(application);
        this.name = Objects.requireNonNull(name);
        this.actions = Collections.unmodifiableSet(actions);
        this.metadata = Collections.unmodifiableMap(metadata);
    }

    public ApplicationPrivilegeDescriptor(StreamInput input) throws IOException {
        this.application = input.readString();
        this.name = input.readString();
        this.actions = input.readCollectionAsImmutableSet(StreamInput::readString);
        this.metadata = Collections.unmodifiableMap(input.readGenericMap());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.application);
        out.writeString(this.name);
        out.writeStringCollection(this.actions);
        out.writeGenericMap(this.metadata);
    }

    public String getApplication() {
        return this.application;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getActions() {
        return this.actions;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, boolean includeTypeField) throws IOException {
        builder.startObject().field(Fields.APPLICATION.getPreferredName(), this.application).field(Fields.NAME.getPreferredName(), this.name).field(Fields.ACTIONS.getPreferredName(), (Collection<String>)this.actions).field(Fields.METADATA.getPreferredName(), this.metadata);
        if (includeTypeField) {
            builder.field(Fields.TYPE.getPreferredName(), DOC_TYPE_VALUE);
        }
        return builder.endObject();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{[" + this.application + "],[" + this.name + "],[" + Strings.collectionToCommaDelimitedString(this.actions) + "]}";
    }

    public static ApplicationPrivilegeDescriptor parse(XContentParser parser, String defaultApplication, String defaultName, boolean allowType) throws IOException {
        Builder builder = PARSER.parse(parser, allowType);
        if (builder.applicationName == null) {
            builder.applicationName(defaultApplication);
        }
        if (builder.privilegeName == null) {
            builder.privilegeName(defaultName);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationPrivilegeDescriptor that = (ApplicationPrivilegeDescriptor)o;
        return Objects.equals(this.application, that.application) && Objects.equals(this.name, that.name) && Objects.equals(this.actions, that.actions) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.name, this.actions, this.metadata);
    }

    static {
        PARSER.declareString(Builder::applicationName, Fields.APPLICATION);
        PARSER.declareString(Builder::privilegeName, Fields.NAME);
        PARSER.declareStringArray(Builder::actions, Fields.ACTIONS);
        PARSER.declareObject(Builder::metadata, (parser, context) -> parser.map(), Fields.METADATA);
        PARSER.declareField((parser, builder, allowType) -> builder.type(parser.text(), (boolean)allowType), Fields.TYPE, ObjectParser.ValueType.STRING);
    }

    public static interface Fields {
        public static final ParseField APPLICATION = new ParseField("application", new String[0]);
        public static final ParseField NAME = new ParseField("name", new String[0]);
        public static final ParseField ACTIONS = new ParseField("actions", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
        public static final ParseField TYPE = new ParseField("type", new String[0]);
    }

    private static final class Builder {
        private String applicationName;
        private String privilegeName;
        private Set<String> actions = Collections.emptySet();
        private Map<String, Object> metadata = Collections.emptyMap();

        private Builder() {
        }

        private Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        private Builder privilegeName(String privilegeName) {
            this.privilegeName = privilegeName;
            return this;
        }

        private Builder actions(Collection<String> actions) {
            this.actions = new LinkedHashSet<String>(actions);
            return this;
        }

        private Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        private Builder type(String type, boolean allowed) {
            if (!allowed) {
                throw new IllegalStateException("Field " + Fields.TYPE.getPreferredName() + " cannot be specified here");
            }
            if (!ApplicationPrivilegeDescriptor.DOC_TYPE_VALUE.equals(type)) {
                throw new IllegalStateException("XContent has wrong " + Fields.TYPE.getPreferredName() + " field " + type);
            }
            return this;
        }

        private ApplicationPrivilegeDescriptor build() {
            return new ApplicationPrivilegeDescriptor(this.applicationName, this.privilegeName, this.actions, this.metadata);
        }
    }
}

