/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class TokensInvalidationResult
implements ToXContentObject,
Writeable {
    private final List<String> invalidatedTokens;
    private final List<String> previouslyInvalidatedTokens;
    private final List<ElasticsearchException> errors;
    private RestStatus restStatus;

    public TokensInvalidationResult(List<String> invalidatedTokens, List<String> previouslyInvalidatedTokens, @Nullable List<ElasticsearchException> errors, RestStatus restStatus) {
        Objects.requireNonNull(invalidatedTokens, "invalidated_tokens must be provided");
        this.invalidatedTokens = invalidatedTokens;
        Objects.requireNonNull(previouslyInvalidatedTokens, "previously_invalidated_tokens must be provided");
        this.previouslyInvalidatedTokens = previouslyInvalidatedTokens;
        this.errors = null != errors ? errors : Collections.emptyList();
        this.restStatus = restStatus;
    }

    public TokensInvalidationResult(StreamInput in) throws IOException {
        this.invalidatedTokens = in.readStringCollectionAsList();
        this.previouslyInvalidatedTokens = in.readStringCollectionAsList();
        this.errors = in.readCollectionAsList(StreamInput::readException);
        this.restStatus = RestStatus.readFrom(in);
    }

    public static TokensInvalidationResult emptyResult(RestStatus restStatus) {
        return new TokensInvalidationResult(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), restStatus);
    }

    public List<String> getInvalidatedTokens() {
        return this.invalidatedTokens;
    }

    public List<String> getPreviouslyInvalidatedTokens() {
        return this.previouslyInvalidatedTokens;
    }

    public List<ElasticsearchException> getErrors() {
        return this.errors;
    }

    public RestStatus getRestStatus() {
        return this.restStatus;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("invalidated_tokens", this.invalidatedTokens.size()).field("previously_invalidated_tokens", this.previouslyInvalidatedTokens.size()).field("error_count", this.errors.size());
        if (!this.errors.isEmpty()) {
            builder.field("error_details");
            builder.startArray();
            for (ElasticsearchException e : this.errors) {
                builder.startObject();
                ElasticsearchException.generateThrowableXContent(builder, params, e);
                builder.endObject();
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.invalidatedTokens);
        out.writeStringCollection(this.previouslyInvalidatedTokens);
        out.writeCollection(this.errors, StreamOutput::writeException);
        RestStatus.writeTo(out, this.restStatus);
    }
}

