/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.concurrent.ThreadContextTransient;
import org.elasticsearch.core.Nullable;

public final class AuthenticationResult<T> {
    private static final AuthenticationResult<?> NOT_HANDLED = new AuthenticationResult<Object>(Status.CONTINUE, null, null, null, null);
    public static final ThreadContextTransient<AuthenticationResult> THREAD_CONTEXT_VALUE = ThreadContextTransient.transientValue("_xpack_security_auth_result", AuthenticationResult.class);
    private final Status status;
    private final T value;
    private final String message;
    private final Exception exception;
    private final Map<String, Object> metadata;

    public static <T> AuthenticationResult<T> get(ThreadContext threadContext) {
        return THREAD_CONTEXT_VALUE.get(threadContext);
    }

    private AuthenticationResult(Status status, @Nullable T value, @Nullable String message, @Nullable Exception exception, @Nullable Map<String, Object> metadata) {
        this.status = status;
        this.value = value;
        this.message = message;
        this.exception = exception;
        this.metadata = metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
    }

    public Status getStatus() {
        return this.status;
    }

    public T getValue() {
        return this.value;
    }

    public String getMessage() {
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public static <T> AuthenticationResult<T> success(T value) {
        return AuthenticationResult.success(value, null);
    }

    public static <T> AuthenticationResult<T> success(T value, @Nullable Map<String, Object> metadata) {
        Objects.requireNonNull(value);
        return new AuthenticationResult<T>(Status.SUCCESS, value, null, null, metadata);
    }

    public static <T> AuthenticationResult<T> notHandled() {
        return NOT_HANDLED;
    }

    public static <T> AuthenticationResult<T> unsuccessful(String message, @Nullable Exception cause) {
        Objects.requireNonNull(message);
        return new AuthenticationResult<Object>(Status.CONTINUE, null, message, cause, null);
    }

    public static <T> AuthenticationResult<T> terminate(String message, @Nullable Exception cause) {
        return new AuthenticationResult<Object>(Status.TERMINATE, null, message, cause, null);
    }

    public static <T> AuthenticationResult<T> terminate(String message) {
        return AuthenticationResult.terminate(message, null);
    }

    public boolean isAuthenticated() {
        return this.status == Status.SUCCESS;
    }

    public String toString() {
        return "AuthenticationResult{status=" + String.valueOf((Object)this.status) + ", value=" + String.valueOf(this.value) + ", message=" + this.message + ", exception=" + String.valueOf(this.exception) + "}";
    }

    public static enum Status {
        SUCCESS,
        CONTINUE,
        TERMINATE;

    }
}

