/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;
import org.elasticsearch.xpack.core.security.support.NativeRealmValidationUtil;
import org.elasticsearch.xpack.core.security.support.Validation;

public class SetEnabledRequest
extends LegacyActionRequest
implements UserRequest,
WriteRequest<SetEnabledRequest> {
    private Boolean enabled;
    private String username;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;

    public SetEnabledRequest() {
    }

    public SetEnabledRequest(StreamInput in) throws IOException {
        super(in);
        this.enabled = in.readBoolean();
        this.username = in.readString();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        Validation.Error error = NativeRealmValidationUtil.validateUsername(this.username, true, Settings.EMPTY);
        if (error != null) {
            validationException = ValidateActions.addValidationError(error.toString(), validationException);
        }
        if (this.enabled == null) {
            validationException = ValidateActions.addValidationError("enabled must be set", validationException);
        }
        return validationException;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String username() {
        return this.username;
    }

    public void username(String username) {
        this.username = username;
    }

    @Override
    public String[] usernames() {
        return new String[]{this.username};
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @Override
    public SetEnabledRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.enabled);
        out.writeString(this.username);
        this.refreshPolicy.writeTo(out);
    }
}

