/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public class AuthenticateResponse
extends ActionResponse
implements ToXContent {
    private final Authentication authentication;
    private final boolean operator;

    public AuthenticateResponse(StreamInput in) throws IOException {
        this.authentication = new Authentication(in);
        this.operator = in.readBoolean();
    }

    public AuthenticateResponse(Authentication authentication, boolean operator) {
        this.authentication = Objects.requireNonNull(authentication);
        this.operator = operator;
    }

    public Authentication authentication() {
        return this.authentication;
    }

    public boolean isOperator() {
        return this.operator;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.authentication.writeTo(out);
        out.writeBoolean(this.operator);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.authentication.toXContentFragment(builder);
        if (this.operator) {
            builder.field("operator", true);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticateResponse that = (AuthenticateResponse)o;
        return this.operator == that.operator && this.authentication.equals(that.authentication);
    }

    public int hashCode() {
        return Objects.hash(this.authentication, this.operator);
    }
}

