/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public final class InvalidateApiKeyRequest
extends LegacyActionRequest {
    private final String realmName;
    private final String userName;
    private final String[] ids;
    private final String name;
    private final boolean ownedByAuthenticatedUser;

    public InvalidateApiKeyRequest() {
        this(null, null, null, false, null);
    }

    public InvalidateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = InvalidateApiKeyRequest.textOrNull(in.readOptionalString());
        this.userName = InvalidateApiKeyRequest.textOrNull(in.readOptionalString());
        this.ids = in.readOptionalStringArray();
        InvalidateApiKeyRequest.validateIds(this.ids);
        this.name = InvalidateApiKeyRequest.textOrNull(in.readOptionalString());
        this.ownedByAuthenticatedUser = in.readOptionalBoolean();
    }

    public InvalidateApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String name, boolean ownedByAuthenticatedUser, @Nullable String[] ids) {
        InvalidateApiKeyRequest.validateIds(ids);
        this.realmName = InvalidateApiKeyRequest.textOrNull(realmName);
        this.userName = InvalidateApiKeyRequest.textOrNull(userName);
        this.ids = ids;
        this.name = InvalidateApiKeyRequest.textOrNull(name);
        this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
    }

    private static String textOrNull(@Nullable String arg) {
        return Strings.hasText(arg) ? arg : null;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public boolean ownedByAuthenticatedUser() {
        return this.ownedByAuthenticatedUser;
    }

    public static InvalidateApiKeyRequest usingRealmName(String realmName) {
        return new InvalidateApiKeyRequest(realmName, null, null, false, null);
    }

    public static InvalidateApiKeyRequest usingUserName(String userName) {
        return new InvalidateApiKeyRequest(null, userName, null, false, null);
    }

    public static InvalidateApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new InvalidateApiKeyRequest(realmName, userName, null, false, null);
    }

    public static InvalidateApiKeyRequest usingApiKeyId(String id, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, null, ownedByAuthenticatedUser, new String[]{id});
    }

    public static InvalidateApiKeyRequest usingApiKeyIds(String[] ids, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, null, ownedByAuthenticatedUser, ids);
    }

    public static InvalidateApiKeyRequest usingApiKeyName(String name, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, name, ownedByAuthenticatedUser, null);
    }

    public static InvalidateApiKeyRequest forOwnedApiKeys() {
        return new InvalidateApiKeyRequest(null, null, null, true, null);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!(Strings.hasText(this.realmName) || Strings.hasText(this.userName) || this.ids != null || Strings.hasText(this.name) || this.ownedByAuthenticatedUser)) {
            validationException = ValidateActions.addValidationError("One of [api key id(s), api key name, username, realm name] must be specified if [owner] flag is false", validationException);
        }
        if ((this.ids != null || Strings.hasText(this.name)) && (Strings.hasText(this.realmName) || Strings.hasText(this.userName))) {
            validationException = ValidateActions.addValidationError("username or realm name must not be specified when the api key id(s) or api key name are specified", validationException);
        }
        if (this.ownedByAuthenticatedUser && (Strings.hasText(this.realmName) || Strings.hasText(this.userName))) {
            validationException = ValidateActions.addValidationError("neither username nor realm-name may be specified when invalidating owned API keys", validationException);
        }
        if (this.ids != null && Strings.hasText(this.name)) {
            validationException = ValidateActions.addValidationError("only one of [api key id(s), api key name] can be specified", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
        out.writeOptionalString(this.userName);
        out.writeOptionalStringArray(this.ids);
        out.writeOptionalString(this.name);
        out.writeOptionalBoolean(this.ownedByAuthenticatedUser);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidateApiKeyRequest that = (InvalidateApiKeyRequest)o;
        return this.ownedByAuthenticatedUser == that.ownedByAuthenticatedUser && Objects.equals(this.realmName, that.realmName) && Objects.equals(this.userName, that.userName) && Arrays.equals(this.ids, that.ids) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.realmName, this.userName, Arrays.hashCode(this.ids), this.name, this.ownedByAuthenticatedUser);
    }

    private static void validateIds(@Nullable String[] idsToValidate) {
        if (idsToValidate != null) {
            if (idsToValidate.length == 0) {
                ActionRequestValidationException validationException = new ActionRequestValidationException();
                validationException.addValidationError("Field [ids] cannot be an empty array");
                throw validationException;
            }
            int[] idxOfBlankIds = IntStream.range(0, idsToValidate.length).filter(i -> !Strings.hasText(idsToValidate[i])).toArray();
            if (idxOfBlankIds.length > 0) {
                ActionRequestValidationException validationException = new ActionRequestValidationException();
                validationException.addValidationError("Field [ids] must not contain blank id, but got blank " + (idxOfBlankIds.length == 1 ? "id" : "ids") + " at index " + (idxOfBlankIds.length == 1 ? "position" : "positions") + ": " + Arrays.toString(idxOfBlankIds));
                throw validationException;
            }
        }
    }
}

