/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.indexing.IndexerState;

public class RollupJobStatus
implements Task.Status,
PersistentTaskState {
    public static final String NAME = "xpack/rollup/job";
    private final IndexerState state;
    @Nullable
    private final TreeMap<String, Object> currentPosition;
    private static final ParseField STATE = new ParseField("job_state", new String[0]);
    private static final ParseField CURRENT_POSITION = new ParseField("current_position", new String[0]);
    private static final ParseField UPGRADED_DOC_ID = new ParseField("upgraded_doc_id", new String[0]);
    public static final ConstructingObjectParser<RollupJobStatus, Void> PARSER = new ConstructingObjectParser("xpack/rollup/job", args -> new RollupJobStatus((IndexerState)args[0], (HashMap)args[1]));
    private static final Writeable.Reader<TreeMap<String, Object>> CURRENT_POSITION_READER;

    public RollupJobStatus(IndexerState state, @Nullable Map<String, Object> position) {
        this.state = state;
        this.currentPosition = position == null ? null : new TreeMap<String, Object>(position);
    }

    public RollupJobStatus(StreamInput in) throws IOException {
        this.state = IndexerState.fromStream(in);
        this.currentPosition = in.readOptional(CURRENT_POSITION_READER);
    }

    public IndexerState getIndexerState() {
        return this.state;
    }

    public Map<String, Object> getPosition() {
        return this.currentPosition;
    }

    public static RollupJobStatus fromXContent(XContentParser parser) {
        try {
            return PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(STATE.getPreferredName(), this.state.value());
        if (this.currentPosition != null) {
            builder.field(CURRENT_POSITION.getPreferredName(), this.currentPosition);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.state.writeTo(out);
        out.writeOptional(StreamOutput::writeGenericMap, this.currentPosition);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJobStatus that = (RollupJobStatus)other;
        return Objects.equals(this.state, that.state) && Objects.equals(this.currentPosition, that.currentPosition);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.currentPosition);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), IndexerState::fromString, STATE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                return p.map();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new IllegalArgumentException("Unsupported token [" + String.valueOf((Object)p.currentToken()) + "]");
        }, CURRENT_POSITION, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), UPGRADED_DOC_ID);
        CURRENT_POSITION_READER = in -> new TreeMap<String, Object>(in.readGenericMap());
    }
}

