/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class AnomalyScoreExplanation
implements ToXContentObject,
Writeable {
    public static final ParseField ANOMALY_SCORE_EXPLANATION = new ParseField("anomaly_score_explanation", new String[0]);
    public static final ParseField ANOMALY_TYPE = new ParseField("anomaly_type", new String[0]);
    public static final ParseField ANOMALY_LENGTH = new ParseField("anomaly_length", new String[0]);
    public static final ParseField SINGLE_BUCKET_IMPACT = new ParseField("single_bucket_impact", new String[0]);
    public static final ParseField MULTI_BUCKET_IMPACT = new ParseField("multi_bucket_impact", new String[0]);
    public static final ParseField ANOMALY_CHARACTERISTICS_IMPACT = new ParseField("anomaly_characteristics_impact", new String[0]);
    public static final ParseField LOWER_CONFIDENCE_BOUND = new ParseField("lower_confidence_bound", new String[0]);
    public static final ParseField TYPICAL_VALUE = new ParseField("typical_value", new String[0]);
    public static final ParseField UPPER_CONFIDENCE_BOUND = new ParseField("upper_confidence_bound", new String[0]);
    public static final ParseField HIGH_VARIANCE_PENALTY = new ParseField("high_variance_penalty", new String[0]);
    public static final ParseField INCOMPLETE_BUCKET_PENALTY = new ParseField("incomplete_bucket_penalty", new String[0]);
    public static final ParseField MULTIMODAL_DISTRIBUTION = new ParseField("multimodal_distribution", new String[0]);
    public static final ParseField BY_FIELD_FIRST_OCCURRENCE = new ParseField("by_field_first_occurrence", new String[0]);
    public static final ParseField BY_FIELD_RELATIVE_RARITY = new ParseField("by_field_relative_rarity", new String[0]);
    public static final ObjectParser<AnomalyScoreExplanation, Void> STRICT_PARSER = AnomalyScoreExplanation.createParser(false);
    public static final ObjectParser<AnomalyScoreExplanation, Void> LENIENT_PARSER = AnomalyScoreExplanation.createParser(true);
    private String anomalyType;
    private Integer anomalyLength;
    private Integer singleBucketImpact;
    private Integer multiBucketImpact;
    private Integer anomalyCharacteristicsImpact;
    private Double lowerConfidenceBound;
    private Double typicalValue;
    private Double upperConfidenceBound;
    private Boolean highVariancePenalty;
    private Boolean incompleteBucketPenalty;
    private Boolean multimodalDistribution;
    private Boolean byFieldFirstOccurrence;
    private Double byFieldRelativeRarity;

    private static ObjectParser<AnomalyScoreExplanation, Void> createParser(Boolean ignoreUnknownFields) {
        ObjectParser<AnomalyScoreExplanation, Void> parser = new ObjectParser<AnomalyScoreExplanation, Void>(ANOMALY_SCORE_EXPLANATION.getPreferredName(), ignoreUnknownFields, AnomalyScoreExplanation::new);
        parser.declareString(AnomalyScoreExplanation::setAnomalyType, ANOMALY_TYPE);
        parser.declareInt(AnomalyScoreExplanation::setAnomalyLength, ANOMALY_LENGTH);
        parser.declareInt(AnomalyScoreExplanation::setSingleBucketImpact, SINGLE_BUCKET_IMPACT);
        parser.declareInt(AnomalyScoreExplanation::setMultiBucketImpact, MULTI_BUCKET_IMPACT);
        parser.declareInt(AnomalyScoreExplanation::setAnomalyCharacteristicsImpact, ANOMALY_CHARACTERISTICS_IMPACT);
        parser.declareDouble(AnomalyScoreExplanation::setLowerConfidenceBound, LOWER_CONFIDENCE_BOUND);
        parser.declareDouble(AnomalyScoreExplanation::setTypicalValue, TYPICAL_VALUE);
        parser.declareDouble(AnomalyScoreExplanation::setUpperConfidenceBound, UPPER_CONFIDENCE_BOUND);
        parser.declareBoolean(AnomalyScoreExplanation::setHighVariancePenalty, HIGH_VARIANCE_PENALTY);
        parser.declareBoolean(AnomalyScoreExplanation::setIncompleteBucketPenalty, INCOMPLETE_BUCKET_PENALTY);
        parser.declareBoolean(AnomalyScoreExplanation::setMultimodalDistribution, MULTIMODAL_DISTRIBUTION);
        parser.declareBoolean(AnomalyScoreExplanation::setByFieldFirstOccurrence, BY_FIELD_FIRST_OCCURRENCE);
        parser.declareDouble(AnomalyScoreExplanation::setByFieldRelativeRarity, BY_FIELD_RELATIVE_RARITY);
        return parser;
    }

    AnomalyScoreExplanation() {
    }

    public AnomalyScoreExplanation(StreamInput in) throws IOException {
        this.anomalyType = in.readOptionalString();
        this.anomalyLength = in.readOptionalInt();
        this.singleBucketImpact = in.readOptionalInt();
        this.multiBucketImpact = in.readOptionalInt();
        this.anomalyCharacteristicsImpact = in.readOptionalInt();
        this.lowerConfidenceBound = in.readOptionalDouble();
        this.typicalValue = in.readOptionalDouble();
        this.upperConfidenceBound = in.readOptionalDouble();
        this.highVariancePenalty = in.readOptionalBoolean();
        this.incompleteBucketPenalty = in.readOptionalBoolean();
        this.multimodalDistribution = in.readOptionalBoolean();
        this.byFieldFirstOccurrence = in.readOptionalBoolean();
        this.byFieldRelativeRarity = in.readOptionalDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.anomalyType);
        out.writeOptionalInt(this.anomalyLength);
        out.writeOptionalInt(this.singleBucketImpact);
        out.writeOptionalInt(this.multiBucketImpact);
        out.writeOptionalInt(this.anomalyCharacteristicsImpact);
        out.writeOptionalDouble(this.lowerConfidenceBound);
        out.writeOptionalDouble(this.typicalValue);
        out.writeOptionalDouble(this.upperConfidenceBound);
        out.writeOptionalBoolean(this.highVariancePenalty);
        out.writeOptionalBoolean(this.incompleteBucketPenalty);
        out.writeOptionalBoolean(this.multimodalDistribution);
        out.writeOptionalBoolean(this.byFieldFirstOccurrence);
        out.writeOptionalDouble(this.byFieldRelativeRarity);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.anomalyType != null) {
            builder.field(ANOMALY_TYPE.getPreferredName(), this.anomalyType);
        }
        if (this.anomalyLength != null) {
            builder.field(ANOMALY_LENGTH.getPreferredName(), this.anomalyLength);
        }
        if (this.singleBucketImpact != null) {
            builder.field(SINGLE_BUCKET_IMPACT.getPreferredName(), this.singleBucketImpact);
        }
        if (this.multiBucketImpact != null) {
            builder.field(MULTI_BUCKET_IMPACT.getPreferredName(), this.multiBucketImpact);
        }
        if (this.anomalyCharacteristicsImpact != null) {
            builder.field(ANOMALY_CHARACTERISTICS_IMPACT.getPreferredName(), this.anomalyCharacteristicsImpact);
        }
        if (this.lowerConfidenceBound != null) {
            builder.field(LOWER_CONFIDENCE_BOUND.getPreferredName(), this.lowerConfidenceBound);
        }
        if (this.typicalValue != null) {
            builder.field(TYPICAL_VALUE.getPreferredName(), this.typicalValue);
        }
        if (this.upperConfidenceBound != null) {
            builder.field(UPPER_CONFIDENCE_BOUND.getPreferredName(), this.upperConfidenceBound);
        }
        if (this.highVariancePenalty != null) {
            builder.field(HIGH_VARIANCE_PENALTY.getPreferredName(), this.highVariancePenalty);
        }
        if (this.incompleteBucketPenalty != null) {
            builder.field(INCOMPLETE_BUCKET_PENALTY.getPreferredName(), this.incompleteBucketPenalty);
        }
        if (this.multimodalDistribution != null) {
            builder.field(MULTIMODAL_DISTRIBUTION.getPreferredName(), this.multimodalDistribution);
        }
        if (this.byFieldFirstOccurrence != null) {
            builder.field(BY_FIELD_FIRST_OCCURRENCE.getPreferredName(), this.byFieldFirstOccurrence);
        }
        if (this.byFieldRelativeRarity != null) {
            builder.field(BY_FIELD_RELATIVE_RARITY.getPreferredName(), this.byFieldRelativeRarity);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.anomalyType, this.anomalyLength, this.singleBucketImpact, this.multiBucketImpact, this.anomalyCharacteristicsImpact, this.lowerConfidenceBound, this.typicalValue, this.upperConfidenceBound, this.highVariancePenalty, this.incompleteBucketPenalty, this.multimodalDistribution, this.byFieldFirstOccurrence, this.byFieldRelativeRarity);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AnomalyScoreExplanation that = (AnomalyScoreExplanation)other;
        return Objects.equals(this.anomalyType, that.anomalyType) && Objects.equals(this.anomalyLength, that.anomalyLength) && Objects.equals(this.singleBucketImpact, that.singleBucketImpact) && Objects.equals(this.multiBucketImpact, that.multiBucketImpact) && Objects.equals(this.anomalyCharacteristicsImpact, that.anomalyCharacteristicsImpact) && Objects.equals(this.lowerConfidenceBound, that.lowerConfidenceBound) && Objects.equals(this.typicalValue, that.typicalValue) && Objects.equals(this.upperConfidenceBound, that.upperConfidenceBound) && Objects.equals(this.highVariancePenalty, that.highVariancePenalty) && Objects.equals(this.incompleteBucketPenalty, that.incompleteBucketPenalty) && Objects.equals(this.multimodalDistribution, that.multimodalDistribution) && Objects.equals(this.byFieldFirstOccurrence, that.byFieldFirstOccurrence) && Objects.equals(this.byFieldRelativeRarity, that.byFieldRelativeRarity);
    }

    public String getAnomalyType() {
        return this.anomalyType;
    }

    public void setAnomalyType(String anomalyType) {
        this.anomalyType = anomalyType;
    }

    public Integer getAnomalyLength() {
        return this.anomalyLength;
    }

    public void setAnomalyLength(Integer anomalyLength) {
        this.anomalyLength = anomalyLength;
    }

    public Integer getSingleBucketImpact() {
        return this.singleBucketImpact;
    }

    public void setSingleBucketImpact(Integer singleBucketImpact) {
        this.singleBucketImpact = singleBucketImpact;
    }

    public Integer getMultiBucketImpact() {
        return this.multiBucketImpact;
    }

    public void setMultiBucketImpact(Integer multiBucketImpact) {
        this.multiBucketImpact = multiBucketImpact;
    }

    public Integer getAnomalyCharacteristicsImpact() {
        return this.anomalyCharacteristicsImpact;
    }

    public void setAnomalyCharacteristicsImpact(Integer anomalyCharacteristicsImpact) {
        this.anomalyCharacteristicsImpact = anomalyCharacteristicsImpact;
    }

    public Double getLowerConfidenceBound() {
        return this.lowerConfidenceBound;
    }

    public void setLowerConfidenceBound(Double lowerConfidenceBound) {
        this.lowerConfidenceBound = lowerConfidenceBound;
    }

    public Double getTypicalValue() {
        return this.typicalValue;
    }

    public void setTypicalValue(Double typicalValue) {
        this.typicalValue = typicalValue;
    }

    public Double getUpperConfidenceBound() {
        return this.upperConfidenceBound;
    }

    public void setUpperConfidenceBound(Double upperConfidenceBound) {
        this.upperConfidenceBound = upperConfidenceBound;
    }

    public Boolean isHighVariancePenalty() {
        return this.highVariancePenalty;
    }

    public void setHighVariancePenalty(Boolean highVariancePenalty) {
        this.highVariancePenalty = highVariancePenalty;
    }

    public Boolean isIncompleteBucketPenalty() {
        return this.incompleteBucketPenalty;
    }

    public void setIncompleteBucketPenalty(Boolean incompleteBucketPenalty) {
        this.incompleteBucketPenalty = incompleteBucketPenalty;
    }

    public Boolean isMultimodalDistribution() {
        return this.multimodalDistribution;
    }

    public void setMultimodalDistribution(Boolean multimodalDistribution) {
        this.multimodalDistribution = multimodalDistribution;
    }

    public Boolean isByFieldFirstOccurrence() {
        return this.byFieldFirstOccurrence;
    }

    public void setByFieldFirstOccurrence(Boolean byFieldFirstOccurrence) {
        this.byFieldFirstOccurrence = byFieldFirstOccurrence;
    }

    public Double getByFieldRelativeRarity() {
        return this.byFieldRelativeRarity;
    }

    public void setByFieldRelativeRarity(Double byFieldRelativeRarity) {
        this.byFieldRelativeRarity = byFieldRelativeRarity;
    }
}

