/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertJapaneseTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertJapaneseTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.DebertaV2TokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.MPNetTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.MPNetTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RobertaTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.XLMRobertaTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public abstract class NlpConfigUpdate
implements InferenceConfigUpdate,
NamedXContentObject {
    protected final TokenizationUpdate tokenizationUpdate;

    public static TokenizationUpdate tokenizationFromMap(Map<String, Object> map) {
        Map tokenization = (Map)map.remove("tokenization");
        if (tokenization == null) {
            return null;
        }
        Map<String, BiFunction<Tokenization.Truncate, Integer, TokenizationUpdate>> knownTokenizers = Map.of(BertTokenization.NAME.getPreferredName(), BertTokenizationUpdate::new, BertJapaneseTokenization.NAME.getPreferredName(), BertJapaneseTokenizationUpdate::new, MPNetTokenization.NAME.getPreferredName(), MPNetTokenizationUpdate::new, RobertaTokenizationUpdate.NAME.getPreferredName(), RobertaTokenizationUpdate::new, XLMRobertaTokenizationUpdate.NAME.getPreferredName(), XLMRobertaTokenizationUpdate::new, "deberta_v2", DebertaV2TokenizationUpdate::new);
        Map tokenizationConfig = null;
        BiFunction<Tokenization.Truncate, Integer, TokenizationUpdate> updater = null;
        for (String tokenizerType : knownTokenizers.keySet()) {
            tokenizationConfig = (Map)tokenization.remove(tokenizerType);
            if (tokenizationConfig == null) continue;
            updater = knownTokenizers.get(tokenizerType);
            break;
        }
        if (tokenizationConfig == null && !tokenization.isEmpty()) {
            throw ExceptionsHelper.badRequestException("unknown tokenization type expecting one of {} got {}", knownTokenizers.keySet().stream().sorted().collect(Collectors.toList()), tokenization.keySet());
        }
        if (tokenizationConfig == null) {
            return null;
        }
        Tokenization.Truncate truncate = Optional.ofNullable(tokenizationConfig.remove("truncate")).map(t -> Tokenization.Truncate.fromString(t.toString())).orElse(null);
        Integer span = Optional.ofNullable(tokenizationConfig.remove("span")).orElse(null);
        if (truncate == null && span == null) {
            return null;
        }
        return updater.apply(truncate, span);
    }

    public NlpConfigUpdate(@Nullable TokenizationUpdate tokenizationUpdate) {
        this.tokenizationUpdate = tokenizationUpdate;
    }

    public NlpConfigUpdate(StreamInput in) throws IOException {
        this.tokenizationUpdate = in.readOptionalNamedWriteable(TokenizationUpdate.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalNamedWriteable(this.tokenizationUpdate);
    }

    protected boolean isNoop() {
        return this.tokenizationUpdate == null || this.tokenizationUpdate.isNoop();
    }

    public TokenizationUpdate getTokenizationUpdate() {
        return this.tokenizationUpdate;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.tokenizationUpdate != null) {
            NamedXContentObjectHelper.writeNamedObject(builder, params, NlpConfig.TOKENIZATION.getPreferredName(), this.tokenizationUpdate);
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public String getName() {
        return InferenceConfigUpdate.super.getName();
    }
}

