/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.QueryProvider;
import org.elasticsearch.xpack.core.ml.utils.RuntimeMappingsValidator;
import org.elasticsearch.xpack.core.ml.utils.XContentObjectTransformer;

public class DataFrameAnalyticsSource
implements Writeable,
ToXContentObject {
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField _SOURCE = new ParseField("_source", new String[0]);
    private final String[] index;
    private final QueryProvider queryProvider;
    private final FetchSourceContext sourceFiltering;
    private final Map<String, Object> runtimeMappings;

    public static ConstructingObjectParser<DataFrameAnalyticsSource, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<DataFrameAnalyticsSource, Void> parser = new ConstructingObjectParser<DataFrameAnalyticsSource, Void>("data_frame_analytics_source", ignoreUnknownFields, a -> new DataFrameAnalyticsSource(((List)a[0]).toArray(new String[0]), (QueryProvider)a[1], (FetchSourceContext)a[2], (Map)a[3]));
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> QueryProvider.fromXContent(p, ignoreUnknownFields, "Data Frame Analytics config query is not parsable"), QUERY);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FetchSourceContext.fromXContent(p), _SOURCE, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD);
        return parser;
    }

    public DataFrameAnalyticsSource(String[] index, @Nullable QueryProvider queryProvider, @Nullable FetchSourceContext sourceFiltering, @Nullable Map<String, Object> runtimeMappings) {
        this.index = ExceptionsHelper.requireNonNull(index, INDEX);
        if (index.length == 0) {
            throw new IllegalArgumentException("source.index must specify at least one index");
        }
        if (Arrays.stream(index).anyMatch(Strings::isNullOrEmpty)) {
            throw new IllegalArgumentException("source.index must contain non-null and non-empty strings");
        }
        QueryProvider queryProvider2 = this.queryProvider = queryProvider == null ? QueryProvider.defaultQuery() : queryProvider;
        if (sourceFiltering != null && !sourceFiltering.fetchSource()) {
            throw new IllegalArgumentException("source._source cannot be disabled");
        }
        this.sourceFiltering = sourceFiltering;
        this.runtimeMappings = runtimeMappings == null ? Collections.emptyMap() : Collections.unmodifiableMap(runtimeMappings);
        RuntimeMappingsValidator.validate(this.runtimeMappings);
    }

    public DataFrameAnalyticsSource(StreamInput in) throws IOException {
        this.index = in.readStringArray();
        this.queryProvider = QueryProvider.fromStream(in);
        this.sourceFiltering = in.readOptionalWriteable(FetchSourceContext::readFrom);
        this.runtimeMappings = in.readGenericMap();
    }

    public DataFrameAnalyticsSource(DataFrameAnalyticsSource other) {
        this.index = Arrays.copyOf(other.index, other.index.length);
        this.queryProvider = new QueryProvider(other.queryProvider);
        this.sourceFiltering = other.sourceFiltering;
        this.runtimeMappings = Collections.unmodifiableMap(new HashMap<String, Object>(other.runtimeMappings));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.index);
        this.queryProvider.writeTo(out);
        out.writeOptionalWriteable(this.sourceFiltering);
        out.writeGenericMap(this.runtimeMappings);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(INDEX.getPreferredName(), this.index);
        builder.field(QUERY.getPreferredName(), this.queryProvider.getQuery());
        if (this.sourceFiltering != null) {
            builder.field(_SOURCE.getPreferredName(), this.sourceFiltering);
        }
        if (!this.runtimeMappings.isEmpty()) {
            builder.field(SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD.getPreferredName(), this.runtimeMappings);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsSource other = (DataFrameAnalyticsSource)o;
        return Arrays.equals(this.index, other.index) && Objects.equals(this.queryProvider, other.queryProvider) && Objects.equals(this.sourceFiltering, other.sourceFiltering) && Objects.equals(this.runtimeMappings, other.runtimeMappings);
    }

    public int hashCode() {
        return Objects.hash(Arrays.asList(this.index), this.queryProvider, this.sourceFiltering, this.runtimeMappings);
    }

    public String[] getIndex() {
        return this.index;
    }

    public QueryBuilder getParsedQuery() {
        Exception exception = this.queryProvider.getParsingException();
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)exception;
                throw runtimeException;
            }
            throw new ElasticsearchStatusException(this.queryProvider.getParsingException().getMessage(), RestStatus.BAD_REQUEST, this.queryProvider.getParsingException(), new Object[0]);
        }
        return this.queryProvider.getParsedQuery();
    }

    public FetchSourceContext getSourceFiltering() {
        return this.sourceFiltering;
    }

    Exception getQueryParsingException() {
        return this.queryProvider.getParsingException();
    }

    QueryProvider getQueryProvider() {
        return this.queryProvider;
    }

    public List<String> getQueryDeprecations(NamedXContentRegistry namedXContentRegistry) {
        ArrayList<String> deprecations = new ArrayList<String>();
        try {
            XContentObjectTransformer.queryBuilderTransformer(namedXContentRegistry).fromMap(this.queryProvider.getQuery(), deprecations);
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof IllegalArgumentException) {
                exception = (Exception)exception.getCause();
            }
            throw ExceptionsHelper.badRequestException("Data Frame Analytics config query is not parsable", exception, new Object[0]);
        }
        return deprecations;
    }

    Map<String, Object> getQuery() {
        return this.queryProvider.getQuery();
    }

    public Map<String, Object> getRuntimeMappings() {
        return this.runtimeMappings;
    }

    public boolean isFieldExcluded(String path) {
        if (this.sourceFiltering == null) {
            return false;
        }
        for (String exclude : this.sourceFiltering.excludes()) {
            if (!DataFrameAnalyticsSource.pathMatchesSourcePattern(path, exclude)) continue;
            return true;
        }
        if (this.sourceFiltering.includes().length == 0) {
            return false;
        }
        for (String include : this.sourceFiltering.includes()) {
            if (!DataFrameAnalyticsSource.pathMatchesSourcePattern(path, include)) continue;
            return false;
        }
        return true;
    }

    private static boolean pathMatchesSourcePattern(String path, String sourcePattern) {
        if (sourcePattern.equals(path)) {
            return true;
        }
        if (Regex.isSimpleMatchPattern(sourcePattern)) {
            return Regex.simpleMatch(sourcePattern, path);
        }
        return Regex.simpleMatch(sourcePattern + ".*", path);
    }
}

