/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExponentialAverageCalculationContext;

public class DatafeedTimingStats
implements ToXContentObject,
Writeable {
    public static final ParseField JOB_ID = new ParseField("job_id", new String[0]);
    public static final ParseField SEARCH_COUNT = new ParseField("search_count", new String[0]);
    public static final ParseField BUCKET_COUNT = new ParseField("bucket_count", new String[0]);
    public static final ParseField TOTAL_SEARCH_TIME_MS = new ParseField("total_search_time_ms", new String[0]);
    public static final ParseField AVG_SEARCH_TIME_PER_BUCKET_MS = new ParseField("average_search_time_per_bucket_ms", new String[0]);
    public static final ParseField EXPONENTIAL_AVG_CALCULATION_CONTEXT = new ParseField("exponential_average_calculation_context", new String[0]);
    public static final ParseField EXPONENTIAL_AVG_SEARCH_TIME_PER_HOUR_MS = new ParseField("exponential_average_search_time_per_hour_ms", new String[0]);
    public static final ParseField TYPE = new ParseField("datafeed_timing_stats", new String[0]);
    public static final ConstructingObjectParser<DatafeedTimingStats, Void> PARSER = DatafeedTimingStats.createParser();
    private final String jobId;
    private long searchCount;
    private long bucketCount;
    private double totalSearchTimeMs;
    private final ExponentialAverageCalculationContext exponentialAvgCalculationContext;

    private static ConstructingObjectParser<DatafeedTimingStats, Void> createParser() {
        ConstructingObjectParser<DatafeedTimingStats, Void> parser = new ConstructingObjectParser<DatafeedTimingStats, Void>(TYPE.getPreferredName(), true, args -> {
            String jobId = (String)args[0];
            Long searchCount = (Long)args[1];
            Long bucketCount = (Long)args[2];
            Double totalSearchTimeMs = (Double)args[3];
            ExponentialAverageCalculationContext exponentialAvgCalculationContext = (ExponentialAverageCalculationContext)args[4];
            return new DatafeedTimingStats(jobId, DatafeedTimingStats.getOrDefault(searchCount, 0L), DatafeedTimingStats.getOrDefault(bucketCount, 0L), DatafeedTimingStats.getOrDefault(totalSearchTimeMs, 0.0), DatafeedTimingStats.getOrDefault(exponentialAvgCalculationContext, new ExponentialAverageCalculationContext()));
        });
        parser.declareString(ConstructingObjectParser.constructorArg(), JOB_ID);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), SEARCH_COUNT);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), BUCKET_COUNT);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TOTAL_SEARCH_TIME_MS);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), ExponentialAverageCalculationContext.PARSER, EXPONENTIAL_AVG_CALCULATION_CONTEXT);
        return parser;
    }

    public static String documentId(String jobId) {
        return jobId + "_datafeed_timing_stats";
    }

    public DatafeedTimingStats(String jobId, long searchCount, long bucketCount, double totalSearchTimeMs, ExponentialAverageCalculationContext exponentialAvgCalculationContext) {
        this.jobId = Objects.requireNonNull(jobId);
        this.searchCount = searchCount;
        this.bucketCount = bucketCount;
        this.totalSearchTimeMs = totalSearchTimeMs;
        this.exponentialAvgCalculationContext = Objects.requireNonNull(exponentialAvgCalculationContext);
    }

    public DatafeedTimingStats(String jobId) {
        this(jobId, 0L, 0L, 0.0, new ExponentialAverageCalculationContext());
    }

    public DatafeedTimingStats(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.searchCount = in.readLong();
        this.bucketCount = in.readLong();
        this.totalSearchTimeMs = in.readDouble();
        this.exponentialAvgCalculationContext = in.readOptionalWriteable(ExponentialAverageCalculationContext::new);
    }

    public DatafeedTimingStats(DatafeedTimingStats other) {
        this(other.jobId, other.searchCount, other.bucketCount, other.totalSearchTimeMs, new ExponentialAverageCalculationContext(other.exponentialAvgCalculationContext));
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getSearchCount() {
        return this.searchCount;
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public double getTotalSearchTimeMs() {
        return this.totalSearchTimeMs;
    }

    public Double getAvgSearchTimePerBucketMs() {
        if (this.bucketCount == 0L) {
            return null;
        }
        return this.totalSearchTimeMs / (double)this.bucketCount;
    }

    public Double getExponentialAvgSearchTimePerHourMs() {
        return this.exponentialAvgCalculationContext.getCurrentExponentialAverageMs();
    }

    ExponentialAverageCalculationContext getExponentialAvgCalculationContext() {
        return this.exponentialAvgCalculationContext;
    }

    public void incrementSearchTimeMs(double searchTimeMs) {
        ++this.searchCount;
        this.totalSearchTimeMs += searchTimeMs;
        this.exponentialAvgCalculationContext.increment(searchTimeMs);
    }

    public void incrementBucketCount(long count) {
        this.bucketCount += count;
    }

    public void setLatestRecordTimestamp(Instant latestRecordTimestamp) {
        this.exponentialAvgCalculationContext.setLatestTimestamp(latestRecordTimestamp);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeLong(this.searchCount);
        out.writeLong(this.bucketCount);
        out.writeDouble(this.totalSearchTimeMs);
        out.writeOptionalWriteable(this.exponentialAvgCalculationContext);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(Result.RESULT_TYPE.getPreferredName(), TYPE.getPreferredName());
        }
        builder.field(JOB_ID.getPreferredName(), this.jobId);
        builder.field(SEARCH_COUNT.getPreferredName(), this.searchCount);
        builder.field(BUCKET_COUNT.getPreferredName(), this.bucketCount);
        builder.field(TOTAL_SEARCH_TIME_MS.getPreferredName(), this.totalSearchTimeMs);
        if (params.paramAsBoolean("include_calculated_fields", false)) {
            Double expAvgSearchTimePerHourMs;
            Double avgSearchTimePerBucketMs = this.getAvgSearchTimePerBucketMs();
            if (avgSearchTimePerBucketMs != null) {
                builder.field(AVG_SEARCH_TIME_PER_BUCKET_MS.getPreferredName(), avgSearchTimePerBucketMs);
            }
            if ((expAvgSearchTimePerHourMs = this.getExponentialAvgSearchTimePerHourMs()) != null) {
                builder.field(EXPONENTIAL_AVG_SEARCH_TIME_PER_HOUR_MS.getPreferredName(), expAvgSearchTimePerHourMs);
            }
        }
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(EXPONENTIAL_AVG_CALCULATION_CONTEXT.getPreferredName(), this.exponentialAvgCalculationContext);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DatafeedTimingStats other = (DatafeedTimingStats)obj;
        return Objects.equals(this.jobId, other.jobId) && this.searchCount == other.searchCount && this.bucketCount == other.bucketCount && this.totalSearchTimeMs == other.totalSearchTimeMs && Objects.equals(this.exponentialAvgCalculationContext, other.exponentialAvgCalculationContext);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.searchCount, this.bucketCount, this.totalSearchTimeMs, this.exponentialAvgCalculationContext);
    }

    public String toString() {
        return Strings.toString(this);
    }

    private static <T> T getOrDefault(@Nullable T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }
}

