/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.annotations;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.TransportClusterHealthAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class AnnotationIndex {
    private static final Logger logger = LogManager.getLogger(AnnotationIndex.class);
    public static final String READ_ALIAS_NAME = ".ml-annotations-read";
    public static final String WRITE_ALIAS_NAME = ".ml-annotations-write";
    public static final String LATEST_INDEX_NAME = ".ml-annotations-000001";
    public static final String INDEX_PATTERN = ".ml-annotations-*";
    public static final List<String> OLD_INDEX_NAMES = List.of(".ml-annotations-6");
    private static final String MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";
    public static final int ANNOTATION_INDEX_MAPPINGS_VERSION = 1;

    public static void createAnnotationsIndexIfNecessaryAndWaitForYellow(Client client, ClusterState state, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        ActionListener<Boolean> annotationsIndexCreatedListener = finalListener.delegateFailureAndWrap((delegate, success) -> {
            ClusterHealthRequest request = new ClusterHealthRequest(masterNodeTimeout, READ_ALIAS_NAME).waitForYellowStatus();
            ClientHelper.executeAsyncWithOrigin(client, "ml", TransportClusterHealthAction.TYPE, request, delegate.delegateFailureAndWrap((l, r) -> l.onResponse(!r.isTimedOut())));
        });
        AnnotationIndex.createAnnotationsIndexIfNecessary(client, state, masterNodeTimeout, annotationsIndexCreatedListener);
    }

    public static void createAnnotationsIndexIfNecessary(Client client, ClusterState state, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        ActionListener<Boolean> checkMappingsListener = finalListener.delegateFailureAndWrap((delegate, success) -> ElasticsearchMappings.addDocMappingIfMissing(WRITE_ALIAS_NAME, AnnotationIndex::annotationsMapping, client, state, masterNodeTimeout, delegate, 1));
        ActionListener<String> createAliasListener = finalListener.delegateFailureAndWrap((finalDelegate, currentIndexName) -> {
            IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases(masterNodeTimeout, TimeValue.THIRTY_SECONDS).addAliasAction(IndicesAliasesRequest.AliasActions.add().index((String)currentIndexName).alias(READ_ALIAS_NAME).isHidden(true)).addAliasAction(IndicesAliasesRequest.AliasActions.add().index((String)currentIndexName).alias(WRITE_ALIAS_NAME).isHidden(true));
            SortedMap<String, IndexAbstraction> lookup = state.getMetadata().getProject().getIndicesLookup();
            for (String oldIndexName : OLD_INDEX_NAMES) {
                IndexAbstraction oldIndexAbstraction = (IndexAbstraction)lookup.get(oldIndexName);
                if (oldIndexAbstraction == null) continue;
                for (Index oldIndex : oldIndexAbstraction.getIndices()) {
                    requestBuilder.removeAlias(oldIndex.getName(), WRITE_ALIAS_NAME);
                }
            }
            ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", (IndicesAliasesRequest)requestBuilder.request(), finalDelegate.delegateFailureAndWrap((l, r) -> checkMappingsListener.onResponse(r.isAcknowledged())), client.admin().indices()::aliases);
        });
        MlMetadata mlMetadata = MlMetadata.getMlMetadata(state);
        SortedMap<String, IndexAbstraction> mlLookup = state.getMetadata().getProject().getIndicesLookup().tailMap(".ml");
        if (!mlMetadata.isResetMode() && !mlMetadata.isUpgradeMode() && !mlLookup.isEmpty() && mlLookup.firstKey().startsWith(".ml")) {
            IndexAbstraction currentIndexAbstraction = (IndexAbstraction)mlLookup.get(LATEST_INDEX_NAME);
            if (currentIndexAbstraction == null) {
                logger.debug(() -> Strings.format("Creating [%s] because [%s] exists; trace %s", LATEST_INDEX_NAME, mlLookup.firstKey(), ExceptionsHelper.formatStackTrace(Thread.currentThread().getStackTrace())));
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(LATEST_INDEX_NAME).mapping(AnnotationIndex.annotationsMapping()).settings(Settings.builder().put("index.auto_expand_replicas", "0-1").put("index.number_of_shards", "1").put("index.hidden", true));
                ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, ActionListener.wrap(r -> createAliasListener.onResponse(LATEST_INDEX_NAME), e -> {
                    if (org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        createAliasListener.onResponse(LATEST_INDEX_NAME);
                    } else {
                        finalListener.onFailure((Exception)e);
                    }
                }), client.admin().indices()::create);
                return;
            }
            String currentIndexName2 = currentIndexAbstraction.getIndices().get(0).getName();
            IndexAbstraction writeAliasAbstraction = (IndexAbstraction)mlLookup.get(WRITE_ALIAS_NAME);
            if (!mlLookup.containsKey(READ_ALIAS_NAME) || writeAliasAbstraction == null) {
                createAliasListener.onResponse(currentIndexName2);
                return;
            }
            List<Index> writeAliasIndices = writeAliasAbstraction.getIndices();
            if (writeAliasIndices.size() != 1 || !currentIndexName2.equals(writeAliasIndices.get(0).getName())) {
                createAliasListener.onResponse(currentIndexName2);
                return;
            }
            checkMappingsListener.onResponse(false);
            return;
        }
        finalListener.onResponse(false);
    }

    public static String annotationsMapping() {
        return TemplateUtils.loadTemplate("/ml/annotations_index_mappings.json", "8.11.0", MAPPINGS_VERSION_VARIABLE, Map.of("xpack.ml.managed.index.version", Integer.toString(1)));
    }
}

