/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.Flow;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.inference.DequeUtils;

public record StreamingChatCompletionResults(Flow.Publisher<? extends InferenceServiceResults.Result> publisher) implements InferenceServiceResults
{
    @Override
    public boolean isStreaming() {
        return true;
    }

    public record Result(String delta) implements ChunkedToXContent,
    Writeable
    {
        public static final String RESULT = "delta";

        private Result(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return ChunkedToXContentHelper.chunk((b, p) -> b.startObject().field(RESULT, this.delta).endObject());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.delta);
        }
    }

    public record Results(Deque<Result> results) implements InferenceServiceResults.Result
    {
        public static final String NAME = "streaming_chat_completion_results";

        public Results(StreamInput in) throws IOException {
            this(DequeUtils.readDeque(in, Result::new));
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat(ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.startArray("completion"), Iterators.flatMap(this.results.iterator(), d -> d.toXContentChunked(params)), ChunkedToXContentHelper.endArray(), ChunkedToXContentHelper.endObject());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.results);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Results other = (Results)o;
            return DequeUtils.dequeEquals(this.results, other.results());
        }

        @Override
        public int hashCode() {
            return DequeUtils.dequeHashCode(this.results);
        }
    }
}

