/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.EmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.MlDenseEmbeddingResults;

public abstract class EmbeddingFloatResults
implements DenseEmbeddingResults<Embedding> {
    final List<Embedding> embeddings;
    private final String arrayName;

    public EmbeddingFloatResults(List<Embedding> embeddings, String arrayName) {
        this.embeddings = embeddings;
        this.arrayName = arrayName;
    }

    public EmbeddingFloatResults(StreamInput in, String arrayName) throws IOException {
        this(in.readCollectionAsList(Embedding::new), arrayName);
    }

    static List<Embedding> getEmbeddingsFromResults(List<? extends InferenceResults> results) {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>(results.size());
        for (InferenceResults inferenceResults : results) {
            if (inferenceResults instanceof MlDenseEmbeddingResults) {
                MlDenseEmbeddingResults embeddingResult = (MlDenseEmbeddingResults)inferenceResults;
                embeddings.add(Embedding.of(embeddingResult));
                continue;
            }
            if (inferenceResults instanceof ErrorInferenceResults) {
                ErrorInferenceResults errorResult = (ErrorInferenceResults)inferenceResults;
                Exception exception = errorResult.getException();
                if (exception instanceof ElasticsearchStatusException) {
                    ElasticsearchStatusException statusException = (ElasticsearchStatusException)exception;
                    throw statusException;
                }
                throw new ElasticsearchStatusException("Received error inference result.", RestStatus.INTERNAL_SERVER_ERROR, errorResult.getException(), new Object[0]);
            }
            throw new IllegalArgumentException("Received invalid inference result, of type " + inferenceResults.getClass().getName() + " but expected " + MlDenseEmbeddingResults.class.getName() + ".");
        }
        return embeddings;
    }

    @Override
    public int getFirstEmbeddingSize() {
        if (this.embeddings.isEmpty()) {
            throw new IllegalStateException("Embeddings list is empty");
        }
        return this.embeddings.getFirst().values().length;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.array(this.arrayName, this.embeddings.iterator());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.embeddings.stream().map(embedding -> new MlDenseEmbeddingResults(this.arrayName, embedding.asDoubleArray(), false)).toList();
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.arrayName, this.embeddings);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddingFloatResults that = (EmbeddingFloatResults)o;
        return Objects.equals(this.embeddings, that.embeddings);
    }

    public int hashCode() {
        return Objects.hash(this.embeddings);
    }

    @Override
    public List<Embedding> embeddings() {
        return this.embeddings;
    }

    public record Embedding(float[] values, int numberOfMergedEmbeddings) implements Writeable,
    ToXContentObject,
    EmbeddingResults.Embedding<Embedding>
    {
        public Embedding(float[] values) {
            this(values, 1);
        }

        public Embedding(StreamInput in) throws IOException {
            this(in.readFloatArray());
        }

        public static Embedding of(MlDenseEmbeddingResults embeddingResult) {
            float[] embeddingAsArray = embeddingResult.getInferenceAsFloat();
            return new Embedding(embeddingAsArray);
        }

        public static Embedding of(List<Float> embeddingValuesList) {
            float[] embeddingValues = new float[embeddingValuesList.size()];
            for (int i = 0; i < embeddingValuesList.size(); ++i) {
                embeddingValues[i] = embeddingValuesList.get(i).floatValue();
            }
            return new Embedding(embeddingValues);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeFloatArray(this.values);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("embedding");
            for (float value : this.values) {
                builder.value(value);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        double[] asDoubleArray() {
            double[] doubles = new double[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                doubles[i] = this.values[i];
            }
            return doubles;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Embedding embedding = (Embedding)o;
            return Arrays.equals(this.values, embedding.values);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.values);
        }

        @Override
        public Embedding merge(Embedding embedding) {
            float[] mergedValues = new float[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                mergedValues[i] = ((float)this.numberOfMergedEmbeddings * this.values[i] + (float)embedding.numberOfMergedEmbeddings * embedding.values[i]) / (float)(this.numberOfMergedEmbeddings + embedding.numberOfMergedEmbeddings);
            }
            return new Embedding(mergedValues, this.numberOfMergedEmbeddings + embedding.numberOfMergedEmbeddings);
        }

        @Override
        public BytesReference toBytesRef(XContent xContent) throws IOException {
            XContentBuilder b = XContentBuilder.builder(xContent);
            b.startArray();
            for (float value : this.values) {
                b.value(value);
            }
            b.endArray();
            return BytesReference.bytes(b);
        }
    }
}

