/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.chunking;

import com.ibm.icu.text.BreakIterator;
import java.util.Locale;

public class ChunkerUtils {
    public static int countWords(String text) {
        BreakIterator wordIterator = BreakIterator.getWordInstance(Locale.ROOT);
        wordIterator.setText(text);
        return ChunkerUtils.countWords(0, text.length(), wordIterator);
    }

    static int countWords(int start, int end, BreakIterator wordIterator) {
        assert (start < end);
        wordIterator.preceding(start);
        int boundary = wordIterator.current();
        int wordCount = 0;
        while (boundary != -1 && boundary <= end) {
            int wordStatus = wordIterator.getRuleStatus();
            if (wordStatus != 0) {
                ++wordCount;
            }
            boundary = wordIterator.next();
        }
        return wordCount;
    }
}

