/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.CleanupGeneratedIndexStep;
import org.elasticsearch.xpack.core.ilm.CleanupSnapshotStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitUntilThresholdStep;
import org.elasticsearch.xpack.core.ilm.CopyExecutionStateStep;
import org.elasticsearch.xpack.core.ilm.CopySettingsStep;
import org.elasticsearch.xpack.core.ilm.CreateSnapshotStep;
import org.elasticsearch.xpack.core.ilm.DeleteStep;
import org.elasticsearch.xpack.core.ilm.ForceMergeStep;
import org.elasticsearch.xpack.core.ilm.GenerateSnapshotNameStep;
import org.elasticsearch.xpack.core.ilm.GenerateUniqueIndexNameStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.MountSnapshotStep;
import org.elasticsearch.xpack.core.ilm.ReadOnlyStep;
import org.elasticsearch.xpack.core.ilm.ReplaceDataStreamBackingIndexStep;
import org.elasticsearch.xpack.core.ilm.ResizeIndexStep;
import org.elasticsearch.xpack.core.ilm.SegmentCountStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.SwapAliasesAndDeleteSourceIndexStep;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;
import org.elasticsearch.xpack.core.ilm.WaitForDataTierStep;
import org.elasticsearch.xpack.core.ilm.WaitForIndexColorStep;
import org.elasticsearch.xpack.core.ilm.WaitForNoFollowersStep;
import org.elasticsearch.xpack.core.ilm.WaitUntilReplicateForTimePassesStep;
import org.elasticsearch.xpack.core.ilm.WaitUntilTimeSeriesEndTimePassesStep;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotRequest;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsConstants;

public class SearchableSnapshotAction
implements LifecycleAction {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotAction.class);
    public static final String NAME = "searchable_snapshot";
    public static final ParseField SNAPSHOT_REPOSITORY = new ParseField("snapshot_repository", new String[0]);
    public static final ParseField FORCE_MERGE_INDEX = new ParseField("force_merge_index", new String[0]);
    public static final ParseField TOTAL_SHARDS_PER_NODE = new ParseField("total_shards_per_node", new String[0]);
    public static final ParseField REPLICATE_FOR = new ParseField("replicate_for", new String[0]);
    public static final ParseField FORCE_MERGE_ON_CLONE = new ParseField("force_merge_on_clone", new String[0]);
    private static final TransportVersion FORCE_MERGE_ON_CLONE_TRANSPORT_VERSION = TransportVersion.fromName("ilm_searchable_snapshot_opt_out_clone");
    public static final String CONDITIONAL_SKIP_ACTION_STEP = "branch-check-prerequisites";
    public static final String CONDITIONAL_SKIP_GENERATE_AND_CLEAN = "branch-check-existing-snapshot";
    public static final String CONDITIONAL_SKIP_CLONE_STEP = "branch-skip-clone-check";
    public static final String WAIT_FOR_CLONED_INDEX_GREEN = "wait-for-index-color-cloned-index";
    public static final String CONDITIONAL_DATASTREAM_CHECK_KEY = "branch-on-datastream-check";
    public static final String CONDITIONAL_DELETE_FORCE_MERGED_INDEX_KEY = "branch-delete-force-merged-index";
    public static final String DELETE_FORCE_MERGED_INDEX_KEY = "delete-force-merged-index";
    public static final String FULL_RESTORED_INDEX_PREFIX = "restored-";
    public static final String PARTIAL_RESTORED_INDEX_PREFIX = "partial-";
    public static final String FORCE_MERGE_CLONE_INDEX_PREFIX = "fm-clone-";
    public static final BiFunction<String, LifecycleExecutionState, String> FORCE_MERGE_CLONE_INDEX_NAME_SUPPLIER = (indexName, state) -> state.forceMergeCloneIndexName();
    public static final BiFunction<String, LifecycleExecutionState, String> FORCE_MERGE_CLONE_INDEX_NAME_FALLBACK_SUPPLIER = (indexName, state) -> state.forceMergeCloneIndexName() != null ? state.forceMergeCloneIndexName() : indexName;
    private static final Settings CLONE_SETTINGS = Settings.builder().put("index.number_of_replicas", 0).put("index.auto_expand_replicas", (String)null).build();
    private static final Function<IndexMetadata, Settings> CLONE_SETTINGS_SUPPLIER = indexMetadata -> CLONE_SETTINGS;
    private static final ConstructingObjectParser<SearchableSnapshotAction, Void> PARSER = new ConstructingObjectParser("searchable_snapshot", a -> new SearchableSnapshotAction((String)a[0], a[1] == null || (Boolean)a[1] != false, (Integer)a[2], (TimeValue)a[3], (Boolean)a[4]));
    private final String snapshotRepository;
    private final boolean forceMergeIndex;
    @Nullable
    private final Integer totalShardsPerNode;
    @Nullable
    private final TimeValue replicateFor;
    @Nullable
    private final Boolean forceMergeOnClone;

    public static SearchableSnapshotAction parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public SearchableSnapshotAction(String snapshotRepository, boolean forceMergeIndex, @Nullable Integer totalShardsPerNode, @Nullable TimeValue replicateFor, @Nullable Boolean forceMergeOnClone) {
        if (!Strings.hasText(snapshotRepository)) {
            throw new IllegalArgumentException("the snapshot repository must be specified");
        }
        this.snapshotRepository = snapshotRepository;
        this.forceMergeIndex = forceMergeIndex;
        if (totalShardsPerNode != null && totalShardsPerNode < 1) {
            throw new IllegalArgumentException("[" + TOTAL_SHARDS_PER_NODE.getPreferredName() + "] must be >= 1");
        }
        this.totalShardsPerNode = totalShardsPerNode;
        if (replicateFor != null && replicateFor.millis() <= 0L) {
            throw new IllegalArgumentException("[" + REPLICATE_FOR.getPreferredName() + "] must be positive [" + replicateFor.getStringRep() + "]");
        }
        this.replicateFor = replicateFor;
        if (!forceMergeIndex && forceMergeOnClone != null) {
            throw new IllegalArgumentException(Strings.format("[%s] is not allowed when [%s] is [false]", FORCE_MERGE_ON_CLONE.getPreferredName(), FORCE_MERGE_INDEX.getPreferredName()));
        }
        this.forceMergeOnClone = forceMergeOnClone;
    }

    public SearchableSnapshotAction(String snapshotRepository, boolean forceMergeIndex) {
        this(snapshotRepository, forceMergeIndex, null, null, null);
    }

    public SearchableSnapshotAction(String snapshotRepository) {
        this(snapshotRepository, true, null, null, null);
    }

    public SearchableSnapshotAction(StreamInput in) throws IOException {
        this.snapshotRepository = in.readString();
        this.forceMergeIndex = in.readBoolean();
        this.totalShardsPerNode = in.readOptionalInt();
        this.replicateFor = in.readOptionalTimeValue();
        this.forceMergeOnClone = in.getTransportVersion().supports(FORCE_MERGE_ON_CLONE_TRANSPORT_VERSION) ? in.readOptionalBoolean() : null;
    }

    public boolean isForceMergeIndex() {
        return this.forceMergeIndex;
    }

    public String getSnapshotRepository() {
        return this.snapshotRepository;
    }

    @Nullable
    public Integer getTotalShardsPerNode() {
        return this.totalShardsPerNode;
    }

    @Nullable
    public TimeValue getReplicateFor() {
        return this.replicateFor;
    }

    @Nullable
    public Boolean isForceMergeOnClone() {
        return this.forceMergeOnClone;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        assert (false);
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey, XPackLicenseState licenseState) {
        Step.StepKey preActionBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_SKIP_ACTION_STEP);
        Step.StepKey checkNoWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey waitForNoFollowerStepKey = new Step.StepKey(phase, NAME, "wait-for-shard-history-leases");
        Step.StepKey waitTimeSeriesEndTimePassesKey = new Step.StepKey(phase, NAME, "check-ts-end-time-passed");
        Step.StepKey skipGeneratingSnapshotKey = new Step.StepKey(phase, NAME, CONDITIONAL_SKIP_GENERATE_AND_CLEAN);
        Step.StepKey conditionalSkipCloneKey = new Step.StepKey(phase, NAME, CONDITIONAL_SKIP_CLONE_STEP);
        Step.StepKey readOnlyKey = new Step.StepKey(phase, NAME, "readonly");
        Step.StepKey cleanupClonedIndexKey = new Step.StepKey(phase, NAME, "cleanup-generated-index");
        Step.StepKey generateCloneIndexNameKey = new Step.StepKey(phase, NAME, "generate-index-name");
        Step.StepKey cloneIndexKey = new Step.StepKey(phase, NAME, "clone");
        Step.StepKey waitForClonedIndexGreenKey = new Step.StepKey(phase, NAME, WAIT_FOR_CLONED_INDEX_GREEN);
        Step.StepKey forceMergeStepKey = new Step.StepKey(phase, NAME, "forcemerge");
        Step.StepKey waitForSegmentCountKey = new Step.StepKey(phase, NAME, "segment-count");
        Step.StepKey generateSnapshotNameKey = new Step.StepKey(phase, NAME, "generate-snapshot-name");
        Step.StepKey cleanSnapshotKey = new Step.StepKey(phase, NAME, "cleanup-snapshot");
        Step.StepKey createSnapshotKey = new Step.StepKey(phase, NAME, "create-snapshot");
        Step.StepKey waitForDataTierKey = new Step.StepKey(phase, NAME, "wait-for-data-tier");
        Step.StepKey mountSnapshotKey = new Step.StepKey(phase, NAME, "mount-snapshot");
        Step.StepKey waitForGreenRestoredIndexKey = new Step.StepKey(phase, NAME, "wait-for-index-color");
        Step.StepKey copyMetadataKey = new Step.StepKey(phase, NAME, "copy-execution-state");
        Step.StepKey dataStreamCheckBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_DATASTREAM_CHECK_KEY);
        Step.StepKey copyLifecyclePolicySettingKey = new Step.StepKey(phase, NAME, "copy-settings");
        Step.StepKey swapAliasesKey = new Step.StepKey(phase, NAME, "swap-aliases");
        Step.StepKey replaceDataStreamIndexKey = new Step.StepKey(phase, NAME, "replace-datastream-backing-index");
        Step.StepKey deleteSourceIndexKey = new Step.StepKey(phase, NAME, "delete");
        Step.StepKey conditionalDeleteForceMergedIndexKey = new Step.StepKey(phase, NAME, CONDITIONAL_DELETE_FORCE_MERGED_INDEX_KEY);
        Step.StepKey deleteForceMergedIndexKey = new Step.StepKey(phase, NAME, DELETE_FORCE_MERGED_INDEX_KEY);
        Step.StepKey replicateForKey = new Step.StepKey(phase, NAME, "check-replicate-for-time-passed");
        Step.StepKey dropReplicasKey = new Step.StepKey(phase, NAME, "update-settings");
        BranchingStep conditionalSkipActionStep = new BranchingStep(preActionBranchingKey, checkNoWriteIndex, nextStepKey, (index, project) -> {
            if (!SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOT_FEATURE.checkWithoutTracking(licenseState)) {
                logger.error("[{}] action is not available in the current license", (Object)NAME);
                throw LicenseUtils.newComplianceException("searchable-snapshots");
            }
            IndexMetadata indexMetadata = project.index((Index)index);
            assert (indexMetadata != null) : "index " + index.getName() + " must exist in the cluster state";
            String policyName = indexMetadata.getLifecyclePolicyName();
            SearchableSnapshotMetadata searchableSnapshotMetadata = SearchableSnapshotAction.extractSearchableSnapshotFromSettings(indexMetadata);
            if (searchableSnapshotMetadata != null) {
                MountSearchableSnapshotRequest.Storage type;
                if (!this.snapshotRepository.equals(searchableSnapshotMetadata.repositoryName)) {
                    logger.debug("[{}] action is configured for index [{}] in policy [{}] which is already mounted as a searchable snapshot, but with a different repository (existing: [{}] vs new: [{}]), a new snapshot and index will be created", (Object)NAME, (Object)index.getName(), (Object)policyName, (Object)searchableSnapshotMetadata.repositoryName, (Object)this.snapshotRepository);
                    return false;
                }
                MountSearchableSnapshotRequest.Storage existingType = searchableSnapshotMetadata.partial ? MountSearchableSnapshotRequest.Storage.SHARED_CACHE : MountSearchableSnapshotRequest.Storage.FULL_COPY;
                if (existingType == (type = SearchableSnapshotAction.getConcreteStorageType(preActionBranchingKey))) {
                    logger.debug("[{}] action is configured for index [{}] in policy [{}] which is already mounted as a searchable snapshot with the same repository [{}] and storage type [{}], skipping this action", (Object)NAME, (Object)index.getName(), (Object)policyName, (Object)searchableSnapshotMetadata.repositoryName, (Object)type);
                    return true;
                }
                logger.debug("[{}] action is configured for index [{}] in policy [{}] which is already mounted as a searchable snapshot in repository [{}], however, the storage type ([{}] vs [{}]) differs, so a new index will be created", (Object)NAME, (Object)index.getName(), (Object)policyName, (Object)this.snapshotRepository, (Object)existingType, (Object)type);
                return false;
            }
            return false;
        });
        CheckNotDataStreamWriteIndexStep checkNoWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNoWriteIndex, waitForNoFollowerStepKey);
        WaitForNoFollowersStep waitForNoFollowersStep = new WaitForNoFollowersStep(waitForNoFollowerStepKey, waitTimeSeriesEndTimePassesKey, client);
        WaitUntilTimeSeriesEndTimePassesStep waitUntilTimeSeriesEndTimeStep = new WaitUntilTimeSeriesEndTimePassesStep(waitTimeSeriesEndTimePassesKey, skipGeneratingSnapshotKey, Instant::now);
        Step.StepKey keyForForceMerge = this.shouldForceMergeOnClone() ? conditionalSkipCloneKey : forceMergeStepKey;
        Step.StepKey keyForSnapshotGeneration = this.forceMergeIndex ? keyForForceMerge : generateSnapshotNameKey;
        BranchingStep skipGeneratingSnapshotStep = new BranchingStep(skipGeneratingSnapshotKey, keyForSnapshotGeneration, waitForDataTierKey, (index, project) -> {
            String repoName;
            String snapshotName;
            String snapshotIndexName;
            IndexMetadata indexMetadata = project.index((Index)index);
            String policyName = indexMetadata.getLifecyclePolicyName();
            LifecycleExecutionState lifecycleExecutionState = indexMetadata.getLifecycleExecutionState();
            SearchableSnapshotMetadata searchableSnapshotMetadata = SearchableSnapshotAction.extractSearchableSnapshotFromSettings(indexMetadata);
            if (lifecycleExecutionState.snapshotName() == null && searchableSnapshotMetadata == null) {
                logger.trace("no snapshot name for index [{}] in policy [{}] exists, so one will be generated", (Object)index.getName(), (Object)policyName);
                return false;
            }
            if (lifecycleExecutionState.snapshotName() != null) {
                snapshotIndexName = lifecycleExecutionState.snapshotIndexName();
                snapshotName = lifecycleExecutionState.snapshotName();
                repoName = lifecycleExecutionState.snapshotRepository();
            } else {
                snapshotIndexName = searchableSnapshotMetadata.sourceIndex;
                snapshotName = searchableSnapshotMetadata.snapshotName;
                repoName = searchableSnapshotMetadata.repositoryName;
            }
            if (!this.snapshotRepository.equals(repoName)) {
                throw new IllegalArgumentException("searchable snapshot indices may be converted only within the same repository");
            }
            logger.debug("Policy [{}] will use an existing snapshot [{}] in repository [{}] (index name: [{}]) to mount [{}] as a searchable snapshot. This snapshot was found in the {}.", (Object)policyName, (Object)snapshotName, (Object)this.snapshotRepository, (Object)snapshotIndexName, (Object)index.getName(), lifecycleExecutionState.snapshotName() != null ? "lifecycle execution state" : "metadata of " + index.getName());
            return true;
        });
        BranchingStep conditionalSkipCloneStep = new BranchingStep(conditionalSkipCloneKey, readOnlyKey, forceMergeStepKey, (index, project) -> {
            IndexMetadata indexMetadata = project.index((Index)index);
            assert (indexMetadata != null) : "index " + index.getName() + " must exist in the cluster state";
            return indexMetadata.getNumberOfReplicas() == 0;
        });
        ReadOnlyStep readOnlyStep = new ReadOnlyStep(readOnlyKey, cleanupClonedIndexKey, client, false);
        CleanupGeneratedIndexStep cleanupClonedIndexStep = new CleanupGeneratedIndexStep(cleanupClonedIndexKey, generateCloneIndexNameKey, client, FORCE_MERGE_CLONE_INDEX_NAME_SUPPLIER);
        GenerateUniqueIndexNameStep generateCloneIndexNameStep = new GenerateUniqueIndexNameStep(generateCloneIndexNameKey, cloneIndexKey, FORCE_MERGE_CLONE_INDEX_PREFIX, (generatedIndexName, lifecycleStateBuilder) -> lifecycleStateBuilder.setForceMergeCloneIndexName((String)generatedIndexName));
        ResizeIndexStep cloneIndexStep = new ResizeIndexStep(cloneIndexKey, waitForClonedIndexGreenKey, client, ResizeType.CLONE, FORCE_MERGE_CLONE_INDEX_NAME_SUPPLIER, CLONE_SETTINGS_SUPPLIER, null);
        ClusterStateWaitUntilThresholdStep waitForClonedIndexGreenStep = new ClusterStateWaitUntilThresholdStep(new WaitForIndexColorStep(waitForClonedIndexGreenKey, forceMergeStepKey, ClusterHealthStatus.GREEN, FORCE_MERGE_CLONE_INDEX_NAME_SUPPLIER), cleanupClonedIndexKey);
        ForceMergeStep forceMergeStep = new ForceMergeStep(forceMergeStepKey, waitForSegmentCountKey, client, 1, FORCE_MERGE_CLONE_INDEX_NAME_FALLBACK_SUPPLIER);
        SegmentCountStep segmentCountStep = new SegmentCountStep(waitForSegmentCountKey, generateSnapshotNameKey, client, 1, FORCE_MERGE_CLONE_INDEX_NAME_FALLBACK_SUPPLIER);
        GenerateSnapshotNameStep generateSnapshotNameStep = new GenerateSnapshotNameStep(generateSnapshotNameKey, cleanSnapshotKey, this.snapshotRepository, FORCE_MERGE_CLONE_INDEX_NAME_FALLBACK_SUPPLIER);
        CleanupSnapshotStep cleanupSnapshotStep = new CleanupSnapshotStep(cleanSnapshotKey, createSnapshotKey, client);
        CreateSnapshotStep createSnapshotStep = new CreateSnapshotStep(createSnapshotKey, waitForDataTierKey, cleanSnapshotKey, client);
        MountSearchableSnapshotRequest.Storage storageType = SearchableSnapshotAction.getConcreteStorageType(mountSnapshotKey);
        WaitForDataTierStep waitForDataTierStep = new WaitForDataTierStep(waitForDataTierKey, mountSnapshotKey, MountSnapshotStep.overrideTierPreference(phase).orElse(storageType.defaultDataTiersPreference()));
        MountSnapshotStep mountSnapshotStep = new MountSnapshotStep(mountSnapshotKey, waitForGreenRestoredIndexKey, client, SearchableSnapshotAction.getRestoredIndexPrefix(mountSnapshotKey), storageType, this.totalShardsPerNode, this.replicateFor != null ? 1 : 0);
        WaitForIndexColorStep waitForGreenIndexHealthStep = new WaitForIndexColorStep(waitForGreenRestoredIndexKey, copyMetadataKey, ClusterHealthStatus.GREEN, SearchableSnapshotAction.getRestoredIndexPrefix(waitForGreenRestoredIndexKey));
        Step.StepKey keyForReplicateForOrContinue = this.replicateFor != null ? replicateForKey : nextStepKey;
        CopyExecutionStateStep copyMetadataStep = new CopyExecutionStateStep(copyMetadataKey, copyLifecyclePolicySettingKey, (index, executionState) -> SearchableSnapshotAction.getRestoredIndexPrefix(copyMetadataKey) + index, keyForReplicateForOrContinue);
        CopySettingsStep copySettingsStep = new CopySettingsStep(copyLifecyclePolicySettingKey, this.forceMergeIndex ? conditionalDeleteForceMergedIndexKey : dataStreamCheckBranchingKey, (index, lifecycleState) -> SearchableSnapshotAction.getRestoredIndexPrefix(copyLifecyclePolicySettingKey) + index, "index.lifecycle.name");
        BranchingStep conditionalDeleteForceMergedIndexStep = new BranchingStep(conditionalDeleteForceMergedIndexKey, dataStreamCheckBranchingKey, deleteForceMergedIndexKey, (index, project) -> {
            IndexMetadata indexMetadata = project.index((Index)index);
            assert (indexMetadata != null) : "index " + index.getName() + " must exist in the cluster state";
            String cloneIndexName = indexMetadata.getLifecycleExecutionState().forceMergeCloneIndexName();
            return cloneIndexName != null && project.index(cloneIndexName) != null;
        });
        DeleteStep deleteForceMergedIndexStep = new DeleteStep(deleteForceMergedIndexKey, dataStreamCheckBranchingKey, client, FORCE_MERGE_CLONE_INDEX_NAME_SUPPLIER, true);
        BranchingStep isDataStreamBranchingStep = new BranchingStep(dataStreamCheckBranchingKey, swapAliasesKey, replaceDataStreamIndexKey, (index, project) -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)project.getIndicesLookup().get(index.getName());
            assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
            return indexAbstraction.getParentDataStream() != null;
        });
        ReplaceDataStreamBackingIndexStep replaceDataStreamBackingIndex = new ReplaceDataStreamBackingIndexStep(replaceDataStreamIndexKey, deleteSourceIndexKey, (index, executionState) -> SearchableSnapshotAction.getRestoredIndexPrefix(replaceDataStreamIndexKey) + index);
        DeleteStep deleteSourceIndexStep = new DeleteStep(deleteSourceIndexKey, null, client);
        SwapAliasesAndDeleteSourceIndexStep swapAliasesAndDeleteSourceIndexStep = new SwapAliasesAndDeleteSourceIndexStep(swapAliasesKey, null, client, SearchableSnapshotAction.getRestoredIndexPrefix(swapAliasesKey));
        WaitUntilReplicateForTimePassesStep replicateForStep = new WaitUntilReplicateForTimePassesStep(replicateForKey, dropReplicasKey, this.replicateFor);
        UpdateSettingsStep dropReplicasStep = new UpdateSettingsStep(dropReplicasKey, nextStepKey, client, Settings.builder().put("index.number_of_replicas", 0).build());
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(conditionalSkipActionStep);
        steps.add(checkNoWriteIndexStep);
        steps.add(waitForNoFollowersStep);
        steps.add(waitUntilTimeSeriesEndTimeStep);
        steps.add(skipGeneratingSnapshotStep);
        if (this.forceMergeIndex) {
            if (this.shouldForceMergeOnClone()) {
                steps.add(conditionalSkipCloneStep);
                steps.add(readOnlyStep);
                steps.add(cleanupClonedIndexStep);
                steps.add(generateCloneIndexNameStep);
                steps.add(cloneIndexStep);
                steps.add(waitForClonedIndexGreenStep);
            }
            steps.add(forceMergeStep);
            steps.add(segmentCountStep);
        }
        steps.add(generateSnapshotNameStep);
        steps.add(cleanupSnapshotStep);
        steps.add(createSnapshotStep);
        steps.add(waitForDataTierStep);
        steps.add(mountSnapshotStep);
        steps.add(waitForGreenIndexHealthStep);
        steps.add(copyMetadataStep);
        steps.add(copySettingsStep);
        if (this.replicateFor != null) {
            steps.add(replicateForStep);
            steps.add(dropReplicasStep);
        }
        if (this.forceMergeIndex) {
            steps.add(conditionalDeleteForceMergedIndexStep);
            steps.add(deleteForceMergedIndexStep);
        }
        steps.add(isDataStreamBranchingStep);
        steps.add(replaceDataStreamBackingIndex);
        steps.add(deleteSourceIndexStep);
        steps.add(swapAliasesAndDeleteSourceIndexStep);
        return steps;
    }

    static String getRestoredIndexPrefix(Step.StepKey currentKey) {
        if (currentKey.phase().equals("frozen")) {
            return PARTIAL_RESTORED_INDEX_PREFIX;
        }
        return FULL_RESTORED_INDEX_PREFIX;
    }

    static MountSearchableSnapshotRequest.Storage getConcreteStorageType(Step.StepKey currentKey) {
        if (currentKey.phase().equals("frozen")) {
            return MountSearchableSnapshotRequest.Storage.SHARED_CACHE;
        }
        return MountSearchableSnapshotRequest.Storage.FULL_COPY;
    }

    private boolean shouldForceMergeOnClone() {
        return this.forceMergeOnClone == null || this.forceMergeOnClone != false;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.snapshotRepository);
        out.writeBoolean(this.forceMergeIndex);
        out.writeOptionalInt(this.totalShardsPerNode);
        out.writeOptionalTimeValue(this.replicateFor);
        if (out.getTransportVersion().supports(FORCE_MERGE_ON_CLONE_TRANSPORT_VERSION)) {
            out.writeOptionalBoolean(this.forceMergeOnClone);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SNAPSHOT_REPOSITORY.getPreferredName(), this.snapshotRepository);
        builder.field(FORCE_MERGE_INDEX.getPreferredName(), this.forceMergeIndex);
        if (this.totalShardsPerNode != null) {
            builder.field(TOTAL_SHARDS_PER_NODE.getPreferredName(), this.totalShardsPerNode);
        }
        if (this.replicateFor != null) {
            builder.field(REPLICATE_FOR.getPreferredName(), this.replicateFor);
        }
        if (this.forceMergeOnClone != null) {
            builder.field(FORCE_MERGE_ON_CLONE.getPreferredName(), this.forceMergeOnClone);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchableSnapshotAction that = (SearchableSnapshotAction)o;
        return Objects.equals(this.snapshotRepository, that.snapshotRepository) && Objects.equals(this.forceMergeIndex, that.forceMergeIndex) && Objects.equals(this.totalShardsPerNode, that.totalShardsPerNode) && Objects.equals(this.replicateFor, that.replicateFor) && Objects.equals(this.forceMergeOnClone, that.forceMergeOnClone);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotRepository, this.forceMergeIndex, this.totalShardsPerNode, this.replicateFor, this.forceMergeOnClone);
    }

    @Nullable
    static SearchableSnapshotMetadata extractSearchableSnapshotFromSettings(IndexMetadata indexMetadata) {
        String indexName = indexMetadata.getSettings().get("index.store.snapshot.index_name");
        if (indexName == null) {
            return null;
        }
        String snapshotName = indexMetadata.getSettings().get("index.store.snapshot.snapshot_name");
        String repo = indexMetadata.getSettings().get("index.store.snapshot.repository_name");
        boolean partial = indexMetadata.getSettings().getAsBoolean("index.store.snapshot.partial", false);
        return new SearchableSnapshotMetadata(indexName, repo, snapshotName, partial);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_REPOSITORY);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FORCE_MERGE_INDEX);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), TOTAL_SHARDS_PER_NODE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeValue.parseTimeValue(p.textOrNull(), REPLICATE_FOR.getPreferredName()), REPLICATE_FOR, ObjectParser.ValueType.STRING);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FORCE_MERGE_ON_CLONE);
    }

    record SearchableSnapshotMetadata(String sourceIndex, String repositoryName, String snapshotName, boolean partial) {
    }
}

