/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.admin.indices.shrink.TransportResizeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class ResizeIndexStep
extends AsyncActionStep {
    public static final String SHRINK = "shrink";
    public static final String CLONE = "clone";
    private static final Logger logger = LogManager.getLogger(ResizeIndexStep.class);
    private final ResizeType resizeType;
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;
    private final Function<IndexMetadata, Settings> targetIndexSettingsSupplier;
    @Nullable
    private final ByteSizeValue maxPrimaryShardSize;

    public ResizeIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, ResizeType resizeType, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier, Function<IndexMetadata, Settings> targetIndexSettingsSupplier, @Nullable ByteSizeValue maxPrimaryShardSize) {
        super(key, nextStepKey, client);
        this.resizeType = resizeType;
        this.targetIndexNameSupplier = targetIndexNameSupplier;
        this.targetIndexSettingsSupplier = targetIndexSettingsSupplier;
        this.maxPrimaryShardSize = maxPrimaryShardSize;
        assert (resizeType == ResizeType.SHRINK || maxPrimaryShardSize == null) : "maxPrimaryShardSize can only be set for shrink operations";
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        if (lifecycleState.lifecycleDate() == null) {
            throw new IllegalStateException("source index [" + indexMetadata.getIndex().getName() + "] is missing lifecycle date");
        }
        String targetIndexName = this.targetIndexNameSupplier.apply(indexMetadata.getIndex().getName(), lifecycleState);
        if (currentState.metadata().index(targetIndexName) != null) {
            logger.warn("skipping [{}] step for index [{}] as part of policy [{}] as the target index [{}] already exists", (Object)this.getKey().name(), (Object)indexMetadata.getIndex().getName(), (Object)indexMetadata.getLifecyclePolicyName(), (Object)targetIndexName);
            listener.onResponse(null);
            return;
        }
        Settings relevantTargetSettings = Settings.builder().put(this.targetIndexSettingsSupplier.apply(indexMetadata)).put("index.lifecycle.skip", true).build();
        ResizeRequest resizeRequest = new ResizeRequest(TimeValue.MAX_VALUE, TimeValue.MAX_VALUE, this.resizeType, indexMetadata.getIndex().getName(), targetIndexName);
        resizeRequest.getTargetIndexRequest().settings(relevantTargetSettings);
        if (this.resizeType == ResizeType.SHRINK) {
            resizeRequest.setMaxPrimaryShardSize(this.maxPrimaryShardSize);
        }
        this.getClient(currentState.projectId()).execute(TransportResizeAction.TYPE, resizeRequest, listener.map(response -> null));
    }

    public ResizeType getResizeType() {
        return this.resizeType;
    }

    public BiFunction<String, LifecycleExecutionState, String> getTargetIndexNameSupplier() {
        return this.targetIndexNameSupplier;
    }

    public Function<IndexMetadata, Settings> getTargetIndexSettingsSupplier() {
        return this.targetIndexSettingsSupplier;
    }

    public ByteSizeValue getMaxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.resizeType, this.maxPrimaryShardSize});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResizeIndexStep other = (ResizeIndexStep)obj;
        return super.equals(obj) && Objects.equals((Object)this.resizeType, (Object)other.resizeType) && Objects.equals(this.maxPrimaryShardSize, other.maxPrimaryShardSize);
    }
}

