/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;

public class IndexLifecycleOriginationDateParser {
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern("uuuu.MM.dd");
    private static final String INDEX_NAME_REGEX = "^.*-(\\d{4}.\\d{2}.\\d{2})(-[\\d]+)?$";
    private static final Pattern INDEX_NAME_PATTERN = Pattern.compile("^.*-(\\d{4}.\\d{2}.\\d{2})(-[\\d]+)?$");

    public static boolean shouldParseIndexName(Settings indexSettings) {
        return indexSettings.getAsLong("index.lifecycle.origination_date", -1L) == -1L && indexSettings.getAsBoolean("index.lifecycle.parse_origination_date", false) != false;
    }

    public static long parseIndexNameAndExtractDate(String indexName) {
        Matcher matcher = INDEX_NAME_PATTERN.matcher(indexName);
        if (matcher.matches()) {
            String dateAsString = matcher.group(1);
            try {
                return DATE_FORMATTER.parseMillis(dateAsString);
            }
            catch (IllegalArgumentException | ElasticsearchParseException e) {
                throw new IllegalArgumentException("index name [" + indexName + "] contains date [" + dateAsString + "] which couldn't be parsed using the 'yyyy.MM.dd' format", e);
            }
        }
        throw new IllegalArgumentException("index name [" + indexName + "] does not match pattern '^.*-(\\d{4}.\\d{2}.\\d{2})(-[\\d]+)?$'");
    }
}

