/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.downsample.DownsampleAction;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class DownsampleStep
extends AsyncActionStep {
    public static final String NAME = "rollup";
    private static final Logger LOGGER = LogManager.getLogger(DownsampleStep.class);
    private final DateHistogramInterval fixedInterval;
    private final TimeValue waitTimeout;
    private final DownsampleConfig.SamplingMethod samplingMethod;

    public DownsampleStep(Step.StepKey key, Step.StepKey nextStepKey, DateHistogramInterval fixedInterval, TimeValue waitTimeout, DownsampleConfig.SamplingMethod samplingMethod, Client client) {
        super(key, nextStepKey, client);
        this.fixedInterval = fixedInterval;
        this.waitTimeout = waitTimeout;
        this.samplingMethod = samplingMethod;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        IndexMetadata.DownsampleTaskStatus downsampleIndexStatus;
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        if (lifecycleState.lifecycleDate() == null) {
            throw new IllegalStateException("source index [" + indexMetadata.getIndex().getName() + "] is missing lifecycle date");
        }
        String policyName = indexMetadata.getLifecyclePolicyName();
        String indexName = indexMetadata.getIndex().getName();
        String downsampleIndexName = lifecycleState.downsampleIndexName();
        IndexMetadata downsampleIndexMetadata = currentState.metadata().index(downsampleIndexName);
        if (downsampleIndexMetadata != null && IndexMetadata.DownsampleTaskStatus.SUCCESS.equals((Object)(downsampleIndexStatus = IndexMetadata.INDEX_DOWNSAMPLE_STATUS.get(downsampleIndexMetadata.getSettings())))) {
            LOGGER.info("skipping [{}] step for index [{}] as part of policy [{}] as the downsample index [{}] already exists", (Object)NAME, (Object)indexName, (Object)policyName, (Object)downsampleIndexName);
            listener.onResponse(null);
            return;
        }
        this.performDownsampleIndex(currentState.projectId(), indexName, downsampleIndexName, listener.delegateFailureAndWrap((l, r) -> l.onResponse(r)));
    }

    void performDownsampleIndex(ProjectId projectId, String indexName, String downsampleIndexName, ActionListener<Void> listener) {
        DownsampleConfig config = new DownsampleConfig(this.fixedInterval, this.samplingMethod);
        DownsampleAction.Request request = new DownsampleAction.Request(TimeValue.MAX_VALUE, indexName, downsampleIndexName, this.waitTimeout, config);
        this.getClient(projectId).execute(DownsampleAction.INSTANCE, request, listener.delegateFailureAndWrap((l, response) -> l.onResponse(null)));
    }

    public DateHistogramInterval getFixedInterval() {
        return this.fixedInterval;
    }

    public TimeValue getWaitTimeout() {
        return this.waitTimeout;
    }

    public DownsampleConfig.SamplingMethod getSamplingMethod() {
        return this.samplingMethod;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fixedInterval, this.waitTimeout, this.samplingMethod);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownsampleStep other = (DownsampleStep)obj;
        return super.equals(obj) && Objects.equals(this.fixedInterval, other.fixedInterval) && Objects.equals(this.waitTimeout, other.waitTimeout) && Objects.equals(this.samplingMethod, other.samplingMethod);
    }
}

