/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class DeleteStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "delete";
    private static final Logger logger = LogManager.getLogger(DeleteStep.class);
    private static final BiFunction<String, LifecycleExecutionState, String> DEFAULT_TARGET_INDEX_NAME_SUPPLIER = (indexName, lifecycleState) -> indexName;
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;
    private final boolean indexSurvives;

    public DeleteStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        this(key, nextStepKey, client, DEFAULT_TARGET_INDEX_NAME_SUPPLIER, false);
    }

    public DeleteStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier, boolean indexSurvives) {
        super(key, nextStepKey, client);
        this.targetIndexNameSupplier = targetIndexNameSupplier;
        this.indexSurvives = indexSurvives;
    }

    @Override
    public void performDuringNoSnapshot(IndexMetadata indexMetadata, ProjectMetadata currentProject, ActionListener<Void> listener) {
        String policyName = indexMetadata.getLifecyclePolicyName();
        String indexName = this.targetIndexNameSupplier.apply(indexMetadata.getIndex().getName(), indexMetadata.getLifecycleExecutionState());
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentProject.getIndicesLookup().get(indexName);
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + indexName + "] was not found";
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream != null) {
            boolean isFailureStoreWriteIndex;
            Index failureStoreWriteIndex = dataStream.getWriteFailureIndex();
            boolean bl = isFailureStoreWriteIndex = failureStoreWriteIndex != null && indexName.equals(failureStoreWriteIndex.getName());
            if (dataStream.getIndices().size() == 1 && !isFailureStoreWriteIndex && dataStream.getWriteIndex().getName().equals(indexName)) {
                DeleteDataStreamAction.Request deleteReq = new DeleteDataStreamAction.Request(MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, dataStream.getName());
                this.getClient(currentProject.id()).execute(DeleteDataStreamAction.INSTANCE, deleteReq, listener.delegateFailureAndWrap((l, response) -> l.onResponse(null)));
                return;
            }
            if (isFailureStoreWriteIndex || dataStream.getWriteIndex().getName().equals(indexName)) {
                String errorMessage = Strings.format("index [%s] is the%s write index for data stream [%s]. stopping execution of lifecycle [%s] as a data stream's write index cannot be deleted. manually rolling over the index will resume the execution of the policy as the index will not be the data stream's write index anymore", indexName, isFailureStoreWriteIndex ? " failure store" : "", dataStream.getName(), policyName);
                logger.debug(errorMessage);
                listener.onFailure(new IllegalStateException(errorMessage));
                return;
            }
        }
        this.getClient(currentProject.id()).admin().indices().delete((DeleteIndexRequest)new DeleteIndexRequest(indexName).masterNodeTimeout(TimeValue.MAX_VALUE), listener.delegateFailureAndWrap((l, response) -> l.onResponse(null)));
    }

    @Override
    public boolean indexSurvives() {
        return this.indexSurvives;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

